/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.knightlib.common.recipe.input.GenericRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record GreatChaliceRecipe(ItemStack input, ItemStack output) implements Recipe<GenericRecipeInput>
{
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"knightlib", (String)"great_chalice_interaction");
    public static final RecipeSerializer<GreatChaliceRecipe> SERIALIZER = new Serializer();
    public static final RecipeType<GreatChaliceRecipe> RECIPE_TYPE = new Type();

    public boolean matches(GenericRecipeInput genericRecipeInput, @NotNull Level level) {
        return ItemStack.isSameItem((ItemStack)genericRecipeInput.getItem(0), (ItemStack)this.input);
    }

    public ItemStack assemble(GenericRecipeInput genericRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public static ResourceLocation getID() {
        return ID;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return RECIPE_TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<GreatChaliceRecipe> {
        public static final MapCodec<GreatChaliceRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ItemStack.CODEC.fieldOf("ingredient").forGetter(GreatChaliceRecipe::input), (App)ItemStack.CODEC.fieldOf("result").forGetter(GreatChaliceRecipe::output)).apply((Applicative)i, GreatChaliceRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GreatChaliceRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, GreatChaliceRecipe::input, (StreamCodec)ItemStack.STREAM_CODEC, GreatChaliceRecipe::output, GreatChaliceRecipe::new);

        @NotNull
        public MapCodec<GreatChaliceRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GreatChaliceRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static final class Type
    implements RecipeType<GreatChaliceRecipe> {
        public String toString() {
            return ID.toString();
        }
    }
}

