/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.knightlib.api.IGreatChaliceInteractable;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.common.entity.BaseProjectile;
import dev.xylonity.knightlib.common.entity.projectile.GreatChaliceStartsetRing;
import dev.xylonity.knightlib.common.recipe.ChaliceFillingRecipe;
import dev.xylonity.knightlib.registry.KnightLibBlocks;
import dev.xylonity.knightlib.registry.KnightLibEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ChaliceFillingRecipeCategory
implements IRecipeCategory<ChaliceFillingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"knightlib", (String)"block_filling");
    public static final RecipeType<ChaliceFillingRecipe> TYPE = new RecipeType(UID, ChaliceFillingRecipe.class);
    public static final ResourceLocation SHADOW = ResourceLocation.fromNamespaceAndPath((String)"knightlib", (String)"textures/gui/shadow.png");
    private GreatChaliceBlockEntity cachedBlockEntity;
    private GreatChaliceStartsetRing cachedEntity;
    private long lastUpdateTime = 0L;
    private final IDrawable icon;
    private long lastEntityAppearTime = 0L;
    private static final long ENTITY_VISIBLE_DURATION = 500L;
    private static final long ENTITY_INTERVAL = 2000L;
    private long lastEntityTickAdvanceTime = 0L;
    private ChaliceFillingRecipe currentRecipe;

    public ChaliceFillingRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)KnightLibBlocks.GREAT_CHALICE.get()));
    }

    @NotNull
    public RecipeType<ChaliceFillingRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.knightlib.great_chalice_fill_interaction.title");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 80;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ChaliceFillingRecipe rec, @NotNull IFocusGroup focuses) {
        this.currentRecipe = rec;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input());
    }

    private GreatChaliceBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new GreatChaliceBlockEntity(BlockPos.ZERO, KnightLibBlocks.GREAT_CHALICE.get().defaultBlockState());
            this.cachedBlockEntity.setCharges(12);
        }
        return this.cachedBlockEntity;
    }

    private GreatChaliceStartsetRing getOrCreateEntity() {
        long currentTime;
        if (this.cachedEntity == null) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                this.cachedEntity = new GreatChaliceStartsetRing((EntityType<? extends BaseProjectile>)KnightLibEntities.GREAT_CHALICE_STARSET_RING.get(), (Level)mc.level);
                this.cachedEntity.setNoGravity(true);
            }
        }
        if (this.cachedEntity != null && (currentTime = System.currentTimeMillis()) - this.lastEntityTickAdvanceTime >= 50L) {
            ++this.cachedEntity.tickCount;
            this.lastEntityTickAdvanceTime = currentTime;
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastEntityAppearTime >= 2000L) {
            GreatChaliceBlockEntity blockEntity;
            int current;
            int next;
            this.lastEntityAppearTime = currentTime;
            GreatChaliceStartsetRing entity = this.getOrCreateEntity();
            if (entity != null) {
                entity.tickCount = 0;
            }
            int amountToAdd = 1;
            Item item = this.currentRecipe.input().getItem();
            if (item instanceof IGreatChaliceInteractable) {
                IGreatChaliceInteractable stack = (IGreatChaliceInteractable)item;
                amountToAdd = stack.getChargesToApply();
            }
            if ((next = (current = (blockEntity = this.getOrCreateBlockEntity()).getCharges()) + amountToAdd) > 12) {
                next = 0;
            }
            blockEntity.setCharges(next);
        }
        this.lastUpdateTime = currentTime;
    }

    public void draw(@NotNull ChaliceFillingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GeoEntityRenderer entityRenderer;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.blit(SHADOW, 21, 55, 0, 0, 39, 17);
        guiGraphics.blit(SHADOW, 33, 10, 46, 3, 33, 22);
        guiGraphics.blit(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        GreatChaliceBlockEntity blockEntity = this.getOrCreateBlockEntity();
        GreatChaliceStartsetRing entity = this.getOrCreateEntity();
        GeoBlockRenderer blockRenderer = (GeoBlockRenderer)Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)blockEntity);
        GeoEntityRenderer geoEntityRenderer = entityRenderer = entity != null ? (GeoEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity) : null;
        if (blockRenderer == null) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        MultiBufferSource.BufferSource buffer = guiGraphics.bufferSource();
        pose.pushPose();
        pose.translate(60.0f, 55.0f, 20.0f);
        pose.scale(24.0f, 24.0f, 24.0f);
        pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
        pose.mulPose(Axis.YP.rotationDegrees(45.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.last().normal();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            blockRenderer.render((BlockEntity)blockEntity, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        catch (Exception e) {
            blockRenderer.render((BlockEntity)blockEntity, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        pose.popPose();
        if (entity != null && System.currentTimeMillis() - this.lastEntityAppearTime < 500L) {
            pose.pushPose();
            pose.translate(60.0, 66.0, 27.5);
            pose.scale(24.0f, 24.0f, 24.0f);
            pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
            pose.mulPose(Axis.YP.rotationDegrees(45.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
            entityRenderer.render((Entity)entity, 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15));
            pose.popPose();
        }
        buffer.endBatch();
    }
}

