/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.event;

import com.mojang.logging.LogUtils;
import fox.mods.access_denied.config.AccessDeniedConfiguration;
import fox.mods.access_denied.requirements.DimensionRequirement;
import fox.mods.access_denied.requirements.DimensionRequirementChecker;
import fox.mods.access_denied.requirements.DimensionRequirementsLoader;
import fox.mods.foxs_core.FoxsCore;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import org.slf4j.Logger;

@EventBusSubscriber
public class PlayerTravelsToDimension {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        PlayerTravelsToDimension.execute(event, event.getEntity());
    }

    public static void execute(Entity entity) {
        PlayerTravelsToDimension.execute(null, entity);
    }

    private static void execute(@Nullable EntityTravelToDimensionEvent event, Entity entity) {
        ResourceKey targetDimensionKey;
        if (entity == null || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        DimensionRequirementsLoader.loadRequirements();
        ResourceKey resourceKey = targetDimensionKey = event != null ? event.getDimension() : null;
        if (targetDimensionKey == null) {
            LOGGER.warn("Could not determine target dimension for player {}", (Object)player.getName().getString());
            return;
        }
        String dimensionKey = targetDimensionKey.location().toString();
        if (AccessDeniedConfiguration.disabledDimensions.contains(dimensionKey)) {
            FoxsCore.cancelEvent((Event)event);
            if (AccessDeniedConfiguration.pushBackPlayer.booleanValue()) {
                PlayerTravelsToDimension.teleportPlayerOutsidePortal((Player)player);
            }
            DimensionRequirementChecker.showAccessDeniedMessage((Player)player);
            return;
        }
        DimensionRequirement requirement = DimensionRequirementsLoader.getRequirements().get(dimensionKey);
        if (requirement == null) {
            return;
        }
        if (!DimensionRequirementChecker.passedRequirements((Player)player, dimensionKey)) {
            FoxsCore.cancelEvent((Event)event);
            if (AccessDeniedConfiguration.pushBackPlayer.booleanValue()) {
                PlayerTravelsToDimension.teleportPlayerOutsidePortal((Player)player);
            }
            DimensionRequirementChecker.ShowRequirementsMessage((Player)player, requirement);
            LOGGER.info("Player {} denied entry to dimension {} due to unmet requirements.", (Object)player.getName().getString(), (Object)dimensionKey);
        }
    }

    private static void teleportPlayerOutsidePortal(Player player) {
        Vec3 lookVec = player.getLookAngle();
        Vec3 teleportVec = player.position().subtract(lookVec.scale(3.0));
        BlockPos teleportPos = new BlockPos((int)teleportVec.x, (int)teleportVec.y, (int)teleportVec.z);
        Level level = player.level();
        BlockState blockState = level.getBlockState(teleportPos);
        if (blockState.isAir()) {
            player.teleportTo(teleportVec.x, teleportVec.y, teleportVec.z);
        } else {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos checkPos = teleportPos.offset(x, y, z);
                        BlockState checkState = level.getBlockState(checkPos);
                        if (!checkState.isAir()) continue;
                        player.teleportTo((double)checkPos.getX(), (double)checkPos.getY(), (double)checkPos.getZ());
                        return;
                    }
                }
            }
        }
    }
}

