/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class GrowthAcceleratorBlock
extends BaseBlock {
    private final int range;
    private final ChatFormatting textColor;

    public GrowthAcceleratorBlock(int range, ChatFormatting textColor) {
        super(SoundType.STONE, 5.0f, 8.0f, true);
        this.range = range;
        this.textColor = textColor;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, GrowthAcceleratorBlock.getTickRate());
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos.betweenClosedStream((BlockPos)pos.above(2), (BlockPos)pos.offset(0, this.range + 2, 0)).filter(aoePos -> level.getBlockState(aoePos).getBlock() instanceof BonemealableBlock).findFirst().ifPresent(aoePos -> level.getBlockState(aoePos).randomTick(level, aoePos, random));
        level.scheduleTick(pos, (Block)this, GrowthAcceleratorBlock.getTickRate());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.GROWTH_ACCELERATOR.build());
        MutableComponent rangeNumber = Component.literal((String)String.valueOf(this.range)).withStyle(this.textColor);
        tooltip.add((Component)ModTooltips.GROWTH_ACCELERATOR_RANGE.args(new Object[]{rangeNumber}).build());
    }

    private static int getTickRate() {
        double variance = Math.random() * 0.20000000000000007 + 0.9;
        return (int)((double)((Integer)ModConfigs.GROWTH_ACCELERATOR_COOLDOWN.get()).intValue() * variance) * 20;
    }
}

