/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.MysticalCropBlock;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class InferiumCropBlock
extends MysticalCropBlock {
    public InferiumCropBlock(Crop crop) {
        super(crop);
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        int age = (Integer)state.getValue((Property)AGE);
        int crop = 0;
        int seed = 1;
        if (age == this.getMaxAge()) {
            crop = 1;
            Vec3 vec = (Vec3)builder.getOptionalParameter(LootContextParams.ORIGIN);
            if (vec != null) {
                BlockPos pos;
                ServerLevel level = builder.getLevel();
                Block below = level.getBlockState((pos = BlockPos.containing((Position)vec)).below()).getBlock();
                if (below instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)below;
                    int tier = farmland.getTier().getValue();
                    crop = (int)(0.5 * (double)tier + 0.5);
                    if (tier > 1 && tier % 2 == 0 && Math.random() < 0.5) {
                        ++crop;
                    }
                }
                double chance = this.getCrop().getSecondaryChance(below);
                if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && Math.random() < chance) {
                    seed = 2;
                }
            }
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (crop > 0) {
            drops.add(new ItemStack(this.getCropsItem(), crop));
        }
        drops.add(new ItemStack(this.getBaseSeedId(), seed));
        return drops;
    }
}

