/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

public class EnchanterCategory
implements IRecipeCategory<IEnchanterRecipe> {
    private static final ResourceLocation TEXTURE = MysticalAgriculture.resource("textures/jei/enchanter.png");
    public static final RecipeType<IEnchanterRecipe> RECIPE_TYPE = RecipeType.create((String)"mysticalagriculture", (String)"enchanter", IEnchanterRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public EnchanterCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 144, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ENCHANTER.get()));
    }

    public RecipeType<IEnchanterRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.mysticalagriculture.enchanter").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IEnchanterRecipe recipe, IFocusGroup focuses) {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStacks(EnchanterCategory.createIngredientItemStack(recipe, 0));
        builder.addSlot(RecipeIngredientRole.INPUT, 23, 5).addItemStacks(EnchanterCategory.createIngredientItemStack(recipe, 1));
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 5).addItemStacks(EnchanterCategory.createIngredientItemStack(recipe, 2));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 123, 5).addItemStacks(EnchanterCategory.createIngredientItemStack(recipe, 3));
    }

    private static List<ItemStack> createIngredientItemStack(IEnchanterRecipe recipe, int slot) {
        if (slot == 2) {
            return List.of(new ItemStack((ItemLike)Items.BOOK));
        }
        Holder<Enchantment> enchantment = recipe.getEnchantment();
        int maxLevel = ((Enchantment)enchantment.value()).getMaxLevel();
        if (slot == 3) {
            return IntStream.rangeClosed(1, maxLevel).mapToObj(i -> EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, i))).toList();
        }
        NonNullList ingredients = recipe.getIngredients();
        return Arrays.stream(((Ingredient)ingredients.get(slot)).getItems()).flatMap(stack -> IntStream.rangeClosed(1, maxLevel).mapToObj(i -> stack.copyWithCount(recipe.getCount(slot) * i))).toList();
    }
}

