/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.generator;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureTags;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagsJsonGenerator
extends TagsProvider<Item> {
    private final PackOutput output;

    public ItemTagsJsonGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, String modId, ExistingFileHelper existingFileHelper) {
        super(output, Registries.ITEM, lookup, modId, existingFileHelper);
        this.output = output;
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            Optional essenceId = BuiltInRegistries.ITEM.getResourceKey((Object)crop.getEssenceItem());
            this.tag(MysticalAgricultureTags.Items.ESSENCES).add((ResourceKey)essenceId.get());
            Optional seedsId = BuiltInRegistries.ITEM.getResourceKey((Object)crop.getSeedsItem());
            this.tag(MysticalAgricultureTags.Items.SEEDS).add((ResourceKey)seedsId.get());
        }
    }

    protected Path getPath(ResourceLocation id) {
        return this.output.getOutputFolder().resolve("data/" + id.getNamespace() + "/tags/item/" + id.getPath() + ".json");
    }

    public String getName() {
        return "Mystical Agriculture item tags generator";
    }
}

