/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.crafting.condition.CropEnabledCondition;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ReprocessorRecipeBuilder {
    private final Ingredient input;
    private final ItemStack result;
    private final List<ICondition> conditions;

    public ReprocessorRecipeBuilder(Ingredient input, ItemStack result) {
        this.input = input;
        this.result = result;
        this.conditions = new ArrayList<ICondition>();
    }

    public void addCondition(ICondition condition) {
        this.conditions.add(condition);
    }

    public void build(RecipeOutput consumer, ResourceLocation id) {
        consumer.accept(id, (Recipe)new ReprocessorRecipe(this.input, this.result), null, this.conditions.toArray(new ICondition[0]));
    }

    public static ReprocessorRecipeBuilder newSeedReprocessingRecipe(Crop crop) {
        Ingredient input = Ingredient.of((ItemLike[])new ItemLike[]{crop.getSeedsItem()});
        Item result = crop.getEssenceItem();
        ReprocessorRecipeBuilder builder = new ReprocessorRecipeBuilder(input, new ItemStack((ItemLike)result, 2));
        builder.addCondition(new CropEnabledCondition(crop.getId()));
        return builder;
    }
}

