/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class MysticalSeedsItem
extends ItemNameBlockItem
implements ICropProvider {
    private final Crop crop;

    public MysticalSeedsItem(Crop crop) {
        super((Block)crop.getCropBlock(), new Item.Properties());
        this.crop = crop;
    }

    public Component getName(ItemStack stack) {
        return Localizable.of((String)"item.mysticalagriculture.mystical_seeds").args(new Object[]{this.crop.getDisplayName()}).build();
    }

    public Component getDescription() {
        return this.getName(ItemStack.EMPTY);
    }

    public String getDescriptionId() {
        return Localizable.of((String)"item.mysticalagriculture.mystical_seeds").args(new Object[]{this.crop.getDisplayName()}).buildString();
    }

    public boolean isFoil(ItemStack stack) {
        return this.crop.hasEffect(stack) || super.isFoil(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> tooltip, TooltipFlag flag) {
        Set<ResourceLocation> biomes;
        MutableComponent tier = this.crop.getTier().getDisplayName();
        tooltip.add((Component)ModTooltips.TIER.args(new Object[]{tier}).build());
        if (!this.crop.getModId().equals("mysticalagriculture")) {
            tooltip.add(ModTooltips.getAddedByTooltip(this.crop.getModId()));
        }
        if (!(biomes = this.crop.getRequiredBiomes()).isEmpty()) {
            tooltip.add((Component)ModTooltips.REQUIRED_BIOMES.build());
            List<MutableComponent> ids = biomes.stream().map(ResourceLocation::toString).map(s -> " - " + s).map(Component::literal).toList();
            tooltip.addAll(ids);
        }
        if (flag.isAdvanced()) {
            tooltip.add((Component)ModTooltips.CROP_ID.args(new Object[]{this.crop.getId().toString()}).color(ChatFormatting.DARK_GRAY).build());
        }
    }

    @Override
    public Crop getCrop() {
        return this.crop;
    }
}

