/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item.tool;

import com.blakebr0.cucumber.item.tool.BaseFishingRodItem;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModDataComponentTypes;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EssenceFishingRodItem
extends BaseFishingRodItem
implements ITinkerable {
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.TOOL, AugmentType.FISHING_ROD);
    private final int tinkerableTier;
    private final int slots;

    public EssenceFishingRodItem(Tier tier, int tinkerableTier, int slots) {
        super(p -> {
            p.component(ModDataComponentTypes.EQUIPPED_AUGMENTS, new ArrayList(slots));
            int uses = tier.getUses();
            if (uses == 0) {
                p.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
            }
            p.durability(uses);
            return p;
        });
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
    }

    public InteractionResult useOn(UseOnContext context) {
        List<Augment> augments = AugmentUtils.getAugments(context.getItemInHand());
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onItemUse(context)) continue;
            success = true;
        }
        if (success) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onRightClick(stack, level, player, hand)) continue;
            success = true;
        }
        if (success) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onRightClickEntity(stack, player, target, hand)) continue;
            success = true;
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = super.hurtEnemy(stack, target, attacker);
        for (Augment augment : augments) {
            if (!augment.onHitEntity(stack, target, attacker)) continue;
            success = true;
        }
        return success;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = super.mineBlock(stack, level, state, pos, entity);
        for (Augment augment : augments) {
            if (!augment.onBlockDestroyed(stack, level, state, pos, entity)) continue;
            success = true;
        }
        return success;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        for (Augment augment : AugmentUtils.getAugments(stack)) {
            augment.onInventoryTick(stack, level, entity, slot, isSelected);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        ModTooltips.addAugmentListToTooltip(tooltip, stack, this.slots);
    }

    public boolean isEnchantable(ItemStack stack) {
        return (Boolean)ModConfigs.ENCHANTABLE_SUPREMIUM_TOOLS.get() != false || super.isEnchantable(stack);
    }

    @Override
    public int getAugmentSlots() {
        return this.slots;
    }

    @Override
    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    @Override
    public int getTinkerableTier() {
        return this.tinkerableTier;
    }
}

