/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.jei.category;

import com.google.common.base.Preconditions;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.ApiStatus;
import plus.dragons.createdragonsplus.util.ErrorMessages;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.GrindingRecipe;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.MechanicalGrindStoneItem;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.integration.jei.category.grinding.GrindingCategory;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.AddressPrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.CopyPrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.CustomNamePrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.EnchantedBookPrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.PatternPrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.PrintingCategory;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.StandardPrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.WrittenBookPrintingRecipeJEI;

@JeiPlugin
public class CEIJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = CEICommon.asResource("jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PrintingCategory(), new GrindingCategory()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = CEIJeiPlugin.getRecipeManager();
        registration.addRecipes(PrintingCategory.TYPE, recipeManager.getAllRecipesFor(CEIRecipes.PRINTING.getType()).stream().map(StandardPrintingRecipeJEI::new).collect(Collectors.toList()));
        ArrayList<Enum> builtinPrinting = new ArrayList<Enum>();
        if (((Boolean)CEIConfig.fluids().enablePackageAddressPrinting.get()).booleanValue()) {
            builtinPrinting.add(AddressPrintingRecipeJEI.INSTANCE);
        }
        if (((Boolean)CEIConfig.fluids().enablePackagePatternPrinting.get()).booleanValue()) {
            builtinPrinting.add(PatternPrintingRecipeJEI.INSTANCE);
        }
        if (((Boolean)CEIConfig.fluids().enableCreateCopiableItemPrinting.get()).booleanValue()) {
            builtinPrinting.add(CopyPrintingRecipeJEI.INSTANCE);
        }
        if (((Boolean)CEIConfig.fluids().enableCustomNamePrinting.get()).booleanValue()) {
            builtinPrinting.add(CustomNamePrintingRecipeJEI.INSTANCE);
        }
        if (((Boolean)CEIConfig.fluids().enableWrittenBookPrinting.get()).booleanValue()) {
            builtinPrinting.add(WrittenBookPrintingRecipeJEI.INSTANCE);
        }
        if (!builtinPrinting.isEmpty()) {
            registration.addRecipes(PrintingCategory.TYPE, builtinPrinting);
        }
        if (((Boolean)CEIConfig.fluids().enableEnchantedBookPrinting.get()).booleanValue()) {
            registration.addRecipes(PrintingCategory.TYPE, EnchantedBookPrintingRecipeJEI.listAll());
        }
        RecipeType manualApplication = (RecipeType)registration.getJeiHelpers().getRecipeType(Create.asResource((String)"item_application")).orElseThrow();
        registration.addRecipes(manualApplication, List.of(MechanicalGrindStoneItem.createRecipe()));
        registration.addRecipes(GrindingCategory.TYPE, recipeManager.getAllRecipesFor(CEIRecipes.GRINDING.getType()));
        net.minecraft.world.item.crafting.RecipeType polishing = AllRecipeTypes.SANDPAPER_POLISHING.getType();
        registration.addRecipes(GrindingCategory.TYPE, recipeManager.getAllRecipesFor(polishing).stream().map(GrindingRecipe::fromPolishing).flatMap(Optional::stream).collect(Collectors.toList()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalysts(PrintingCategory.TYPE, new ItemLike[]{CEIBlocks.PRINTER});
        registration.addRecipeCatalysts(GrindingCategory.TYPE, new ItemLike[]{CEIBlocks.MECHANICAL_GRINDSTONE});
    }

    @ApiStatus.Internal
    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving recipe manager from client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)ErrorMessages.notNull((String)"minecraft"));
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)ErrorMessages.notNull((String)"level"));
        return level.getRecipeManager();
    }
}

