/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import java.util.List;
import net.minecraft.world.level.block.Rotation;

public class RotationCondition
extends StructureCondition {
    public static final MapCodec<RotationCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Rotation.CODEC.listOf().fieldOf("rotations").forGetter(conditon -> conditon.validRotations)).apply((Applicative)builder, RotationCondition::new));
    private final List<Rotation> validRotations;

    public RotationCondition(List<Rotation> validRotations) {
        this.validRotations = validRotations;
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.ROTATION;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        Rotation rotation = ctx.rotation();
        if (rotation == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'rotation' for rotation condition!");
        }
        if (rotation == null) {
            return false;
        }
        return this.validRotations.contains(rotation);
    }
}

