/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.client.gui;

import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum Mode implements StringRepresentable
{
    EXPOSURES("exposures"),
    TEXTURES("textures");

    private final String name;

    private Mode(String name) {
        this.name = name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public static Mode fromSerializedString(String str) {
        for (Mode value : Mode.values()) {
            if (!value.getSerializedName().equals(str)) continue;
            return value;
        }
        throw new IllegalArgumentException(str + " cannot be deserialized to Mode");
    }
}

