/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.data.server;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure_catalog.data.ExposureInfo;
import io.github.mortuusars.exposure_catalog.data.ExposureThumbnail;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.Util;
import org.slf4j.Logger;

public class CatalogCache {
    protected Logger LOGGER = LogUtils.getLogger();
    protected AtomicBoolean isBuilding = new AtomicBoolean(false);
    protected ConcurrentMap<String, ExposureInfo> exposures = new ConcurrentHashMap<String, ExposureInfo>();
    protected ConcurrentMap<String, ExposureThumbnail> thumbnails = new ConcurrentHashMap<String, ExposureThumbnail>();
    protected List<Runnable> callbacks = Collections.synchronizedList(new ArrayList());

    public Map<String, ExposureInfo> getExposures() {
        return this.exposures;
    }

    public Map<String, ExposureThumbnail> getThumbnails() {
        return this.thumbnails;
    }

    public boolean isCurrentlyBuilding() {
        return this.isBuilding.get();
    }

    public synchronized void buildIfNeeded(Runnable onFinished) {
        if (!this.exposures.isEmpty() && !this.isCurrentlyBuilding()) {
            onFinished.run();
            return;
        }
        this.callbacks.add(onFinished);
        if (!this.isCurrentlyBuilding()) {
            new Thread(this::rebuildCache).start();
        }
    }

    public synchronized void rebuild(Runnable onFinished) {
        this.callbacks.add(onFinished);
        this.exposures.clear();
        this.thumbnails.clear();
        this.rebuildCache();
    }

    public void addExposure(String exposureId, ExposureData data) {
        ExposureInfo exposureInfo = !data.equals((Object)ExposureData.EMPTY) ? new ExposureInfo(exposureId, data.getWidth(), data.getHeight(), data.getPaletteId(), data.getTag()) : ExposureInfo.empty(exposureId);
        this.exposures.put(exposureId, exposureInfo);
        ExposureThumbnail thumbnail = this.createThumbnail(data, this.getThumbnailSize());
        this.thumbnails.put(exposureId, thumbnail);
    }

    public void removeExposure(String exposureId) {
        this.exposures.remove(exposureId);
        this.thumbnails.remove(exposureId);
    }

    public void clear() {
        this.exposures.clear();
        this.thumbnails.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void rebuildCache() {
        block13: {
            this.isBuilding.set(true);
            try {
                this.clear();
                this.LOGGER.info("Building exposures cache...");
                List exposureIds = ExposureServer.exposureRepository().getAllIds();
                if (exposureIds.isEmpty()) {
                    this.LOGGER.info("No exposures have been found.");
                    return;
                }
                this.LOGGER.info("Loading {} exposures...", (Object)exposureIds.size());
                long start = Util.getMillis();
                List chunks = Lists.partition((List)exposureIds, (int)600);
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (List chunk : chunks) {
                    Thread thread = new Thread(() -> this.processExposures(chunk));
                    threads.add(thread);
                    thread.start();
                }
                for (Thread thread : threads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        this.LOGGER.error(e.toString());
                    }
                }
                this.LOGGER.info("{} exposures loaded in {}ms.", (Object)exposureIds.size(), (Object)(Util.getMillis() - start));
                this.isBuilding.set(false);
            }
            catch (Exception e) {
                this.LOGGER.error("Error occurred when building exposures cache: {}", (Object)e.toString());
                break block13;
            }
            finally {
                this.isBuilding.set(false);
                for (Runnable callback : this.callbacks) {
                    callback.run();
                }
                this.callbacks.clear();
            }
            for (Runnable callback : this.callbacks) {
                callback.run();
            }
            this.callbacks.clear();
        }
    }

    protected void processExposures(List<String> exposureIds) {
        for (String id : exposureIds) {
            ExposureData exposureData = ExposureServer.exposureRepository().load(id).orElse(ExposureData.EMPTY);
            this.addExposure(id, exposureData);
        }
    }

    public int getThumbnailSize() {
        return 54;
    }

    public ExposureThumbnail createThumbnail(ExposureData exposure, int size) {
        if (exposure.equals((Object)ExposureData.EMPTY)) {
            return new ExposureThumbnail(1, 1, new byte[]{0}, ColorPalettes.DEFAULT.location());
        }
        float scaleFactorX = (float)size / (float)exposure.getWidth();
        float scaleFactorY = (float)size / (float)exposure.getHeight();
        byte[] pixels = new byte[size * size];
        for (int y = 0; y < size; ++y) {
            int yIndex = (int)((float)y / scaleFactorY);
            for (int x = 0; x < size; ++x) {
                byte pixel;
                int xIndex = (int)((float)x / scaleFactorX);
                pixels[y * size + x] = pixel = exposure.getPixel(xIndex, yIndex);
            }
        }
        return new ExposureThumbnail(size, size, pixels, exposure.getPaletteId());
    }
}

