/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.neoforge.event;

import com.mojang.brigadier.CommandDispatcher;
import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.command.CatalogCommand;
import io.github.mortuusars.exposure_catalog.neoforge.NeoForgePermissions;
import io.github.mortuusars.exposure_catalog.network.neoforge.PacketsImpl;
import io.github.mortuusars.exposure_catalog.network.packet.C2SPackets;
import io.github.mortuusars.exposure_catalog.network.packet.CommonPackets;
import io.github.mortuusars.exposure_catalog.network.packet.S2CPackets;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;

public class NeoForgeCommonEvents {

    @EventBusSubscriber(modid="exposure_catalog", bus=EventBusSubscriber.Bus.GAME)
    public static class ForgeBus {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            CatalogCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void registerPermissions(PermissionGatherEvent.Nodes event) {
            event.addNodes(new PermissionNode[]{NeoForgePermissions.CATALOG_COMMAND});
        }
    }

    @EventBusSubscriber(modid="exposure_catalog", bus=EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(ExposureCatalog.Stats::register);
        }

        @SubscribeEvent
        public static void registerPackets(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : S2CPackets.getDefinitions()) {
                registrar.playToClient(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : C2SPackets.getDefinitions()) {
                registrar.playToServer(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : CommonPackets.getDefinitions()) {
                registrar.playBidirectional(definition.type(), definition.codec(), PacketsImpl::handle);
            }
        }
    }
}

