/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.client.render;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.items.storage.StorageCellTooltipComponent;
import gripe._90.megacells.definition.MEGATranslations;
import gripe._90.megacells.item.cell.PortableCellWorkbenchTooltipComponent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public record PortableCellWorkbenchClientTooltipComponent(PortableCellWorkbenchTooltipComponent tooltipComponent) implements ClientTooltipComponent
{
    private static final Component CELL_LABEL = MEGATranslations.WorkbenchCell.text();
    private static final Component CONFIG_LABEL = MEGATranslations.WorkbenchConfig.text();

    public int getHeight() {
        Optional cellOpt;
        int height = 0;
        if (!this.tooltipComponent.config().isEmpty()) {
            height += 17;
        }
        if ((cellOpt = this.tooltipComponent.cell().getTooltipImage()).isPresent() && cellOpt.get() instanceof StorageCellTooltipComponent) {
            height += 17;
        }
        return height;
    }

    public int getWidth(@NotNull Font font) {
        Object t;
        Optional cellOpt;
        int width = 0;
        if (!this.tooltipComponent.config().isEmpty()) {
            int configWidth = this.tooltipComponent.config().size() * 17;
            if (this.tooltipComponent.hasMoreConfig()) {
                configWidth += 10;
            }
            width = font.width((FormattedText)CONFIG_LABEL) + 2 + Math.max(width, configWidth);
        }
        if ((cellOpt = this.tooltipComponent.cell().getTooltipImage()).isPresent() && (t = cellOpt.get()) instanceof StorageCellTooltipComponent) {
            StorageCellTooltipComponent cellComponent = (StorageCellTooltipComponent)t;
            width = Math.max(width, font.width((FormattedText)CELL_LABEL) + 2 + 17 * (cellComponent.upgrades().size() + 1));
        }
        return width;
    }

    public void renderText(@NotNull Font font, int x, int y, @NotNull Matrix4f matrix, @NotNull MultiBufferSource.BufferSource bufferSource) {
        Objects.requireNonNull(font);
        y += (16 - 9) / 2;
        if (!this.tooltipComponent.config().isEmpty()) {
            font.drawInBatch(CONFIG_LABEL, (float)x, (float)y, 0x7E7E7E, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            if (this.tooltipComponent.hasMoreConfig()) {
                font.drawInBatch("\u2026", (float)(x + font.width((FormattedText)CONFIG_LABEL) + 4 + this.tooltipComponent.config().size() * 17), (float)(y + 2), -1, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            y += 17;
        }
        if (!this.tooltipComponent.cell().isEmpty()) {
            font.drawInBatch(CELL_LABEL, (float)x, (float)y, 0x7E7E7E, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
        Object t;
        Optional cellOpt;
        List<GenericStack> config = this.tooltipComponent.config();
        if (!config.isEmpty()) {
            int xOff = font.width((FormattedText)CONFIG_LABEL) + 2;
            for (GenericStack genericStack : config) {
                AEKeyRendering.drawInGui((Minecraft)Minecraft.getInstance(), (GuiGraphics)guiGraphics, (int)(x + xOff), (int)y, (AEKey)genericStack.what());
                xOff += 17;
            }
            y += 17;
        }
        if ((cellOpt = this.tooltipComponent.cell().getTooltipImage()).isPresent() && (t = cellOpt.get()) instanceof StorageCellTooltipComponent) {
            StorageCellTooltipComponent cellComponent = (StorageCellTooltipComponent)t;
            int n = font.width((FormattedText)CELL_LABEL) + 2;
            guiGraphics.renderItem(this.tooltipComponent.cell(), x + n, y);
            List upgrades = cellComponent.upgrades();
            if (!upgrades.isEmpty()) {
                var8_12 += 17;
                for (ItemStack upgrade : upgrades) {
                    void var8_13;
                    guiGraphics.renderItem(upgrade, x + var8_13, y);
                    var8_13 += 17;
                }
            }
        }
    }
}

