/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.definition;

import appeng.api.stacks.AEKey;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import gripe._90.megacells.misc.DecompressionPattern;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class MEGAComponents {
    public static final DeferredRegister<DataComponentType<?>> DR = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"megacells");
    public static final DataComponentType<AEKey> BULK_CELL_ITEM = MEGAComponents.register("bulk_item", AEKey.CODEC, AEKey.STREAM_CODEC);
    public static final DataComponentType<Integer> BULK_CELL_COMPRESSION_CUTOFF = MEGAComponents.register("compression_cutoff", Codec.INT, ByteBufCodecs.VAR_INT);
    private static final Codec<BigInteger> BIG_INTEGER_CODEC = Codec.STRING.comapFlatMap(str -> {
        try {
            return DataResult.success((Object)new BigInteger((String)str));
        }
        catch (NumberFormatException e) {
            return DataResult.error(e::getMessage);
        }
    }, BigInteger::toString);
    private static final StreamCodec<ByteBuf, BigInteger> BIG_INTEGER_STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(str -> {
        try {
            return new BigInteger((String)str);
        }
        catch (NumberFormatException e) {
            return BigInteger.ZERO;
        }
    }, BigInteger::toString);
    public static final DataComponentType<BigInteger> BULK_CELL_UNIT_COUNT = MEGAComponents.register("bulk_unit_count", BIG_INTEGER_CODEC, BIG_INTEGER_STREAM_CODEC);
    public static final DataComponentType<BigInteger> BULK_CELL_UNIT_FACTOR = MEGAComponents.register("bulk_unit_factor", BIG_INTEGER_CODEC, BIG_INTEGER_STREAM_CODEC);
    public static final DataComponentType<DecompressionPattern.Encoded> ENCODED_DECOMPRESSION_PATTERN = MEGAComponents.register("encoded_decompression_pattern", DecompressionPattern.Encoded.CODEC, DecompressionPattern.Encoded.STREAM_CODEC);
    public static final DataComponentType<AEKey> RADIOACTIVE_CELL_CHEMICAL = MEGAComponents.register("radioactive_chemical", AEKey.CODEC, AEKey.STREAM_CODEC);
    public static final DataComponentType<Long> RADIOACTIVE_CELL_AMOUNT = MEGAComponents.register("radioactive_amount", Codec.LONG, ByteBufCodecs.VAR_LONG);

    private static <T> DataComponentType<T> register(String name, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        DataComponentType componentType = DataComponentType.builder().persistent(codec).networkSynchronized(streamCodec).build();
        DR.register(name, () -> componentType);
        return componentType;
    }
}

