/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.misc.CompressionService;
import gripe._90.megacells.misc.DecompressionPattern;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.Lazy;

public class CompressionChain {
    public static final StreamCodec<RegistryFriendlyByteBuf, CompressionChain> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(CompressionChain::new, chain -> chain.variants);
    public static final long STACK_LIMIT = (long)Math.pow(2.0, 42.0);
    private final List<ItemStack> variants;
    private final Supplier<List<Pair<IPatternDetails, IPatternDetails>>> patterns = Lazy.of(this::gatherPatterns);

    CompressionChain(List<ItemStack> variants) {
        this.variants = Collections.unmodifiableList(variants);
    }

    public static long clamp(BigInteger toClamp, long limit) {
        return toClamp.min(BigInteger.valueOf(limit)).longValue();
    }

    private static BigInteger bigCount(ItemStack stack) {
        return BigInteger.valueOf(stack.getCount());
    }

    public boolean isEmpty() {
        return this.variants.isEmpty();
    }

    public boolean containsVariant(AEItemKey item) {
        for (ItemStack variant : this.variants) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)item.getReadOnlyStack(), (ItemStack)variant)) continue;
            return true;
        }
        return false;
    }

    public ItemStack getItem(int index) {
        return this.variants.get(index).copy();
    }

    public BigInteger unitFactor(AEItemKey item) {
        if (item == null) {
            return BigInteger.ONE;
        }
        BigInteger potentialFactor = BigInteger.ONE;
        for (ItemStack variant : this.variants) {
            potentialFactor = potentialFactor.multiply(CompressionChain.bigCount(variant));
            if (!ItemStack.isSameItemSameComponents((ItemStack)item.getReadOnlyStack(), (ItemStack)variant)) continue;
            return potentialFactor;
        }
        return BigInteger.ONE;
    }

    public int size() {
        return this.variants.size();
    }

    public List<IPatternDetails> getDecompressionPatterns(int cutoff) {
        int i;
        if (this.isEmpty()) {
            return List.of();
        }
        ObjectArrayList decompressionPatterns = new ObjectArrayList();
        List<Pair<IPatternDetails, IPatternDetails>> availablePatterns = this.patterns.get();
        for (i = 0; i < this.variants.subList(0, cutoff).size(); ++i) {
            decompressionPatterns.add((Object)((IPatternDetails)availablePatterns.get(i).right()));
        }
        for (i = cutoff; i < this.variants.size() - 1; ++i) {
            decompressionPatterns.add((Object)((IPatternDetails)availablePatterns.get(i).left()));
        }
        return Collections.unmodifiableList(decompressionPatterns);
    }

    private List<Pair<IPatternDetails, IPatternDetails>> gatherPatterns() {
        ObjectArrayList patterns = new ObjectArrayList();
        for (int i = 0; i < this.variants.size() - 1; ++i) {
            ItemStack smaller = this.variants.get(i).copyWithCount(this.variants.get(i + 1).getCount());
            ItemStack larger = this.variants.get(i + 1).copyWithCount(1);
            DecompressionPattern compression = new DecompressionPattern(smaller, larger);
            DecompressionPattern decompression = new DecompressionPattern(larger, smaller);
            patterns.add((Object)Pair.of((Object)compression, (Object)decompression));
        }
        return patterns;
    }

    public Map<AEItemKey, Long> initStacks(BigInteger unitCount, int cutoff, AEItemKey fallback) {
        Object2LongLinkedOpenHashMap stacks = new Object2LongLinkedOpenHashMap();
        if (!this.isEmpty()) {
            for (int i = 0; i < cutoff + 1; ++i) {
                AEItemKey variant = AEItemKey.of((ItemStack)this.variants.get(i));
                if (i >= cutoff) {
                    stacks.put((Object)variant, CompressionChain.clamp(unitCount, STACK_LIMIT));
                    break;
                }
                BigInteger factor = CompressionChain.bigCount(this.variants.get((i + 1) % this.variants.size()));
                stacks.put((Object)variant, unitCount.remainder(factor).longValue());
                unitCount = unitCount.divide(factor);
            }
        } else if (fallback != null) {
            stacks.put((Object)fallback, CompressionChain.clamp(unitCount, STACK_LIMIT));
        }
        return stacks;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass() && ((CompressionChain)o).variants.equals(this.variants);
    }

    public int hashCode() {
        return Objects.hashCode(this.variants);
    }

    public String toString() {
        Iterator<ItemStack> it = this.variants.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            ItemStack stack = it.next();
            sb.append(stack.getCount());
            sb.append("x \u2192 ");
            sb.append(CompressionService.variantString(stack));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }
}

