/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.Furnace;
import com.epherical.croptopia.register.helpers.IceCream;
import com.epherical.croptopia.register.helpers.Jam;
import com.epherical.croptopia.register.helpers.Juice;
import com.epherical.croptopia.register.helpers.Pie;
import com.epherical.croptopia.register.helpers.Seafood;
import com.epherical.croptopia.register.helpers.Smoothie;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.epherical.croptopia.register.helpers.Utensil;
import com.epherical.croptopia.util.PluralInfo;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class CroptopiaIndependentItemTagProvider
extends ItemTagsProvider {
    public CroptopiaIndependentItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Item>> parentProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, parentProvider, blockTags, "croptopia", existingFileHelper);
    }

    public String getName() {
        return "Croptopia Independent Tags";
    }

    protected void addTags(HolderLookup.Provider arg) {
        this.generateCrops(arg);
        this.generateSeedsSaplings();
        this.generateOtherEnums(arg);
        this.generateMisc();
    }

    protected void generateCrops(HolderLookup.Provider arg) {
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            this.createCategoryTag(farmlandCrop.getTagCategory().getLowerCaseName(), PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural()), farmlandCrop.asItem(), arg);
            if (farmlandCrop.getTagCategory() == TagCategory.CROPS) continue;
            this.createCategoryTag(TagCategory.CROPS.getLowerCaseName(), PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural()), farmlandCrop.asItem(), arg);
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            this.createCategoryTag(treeCrop.getTagCategory().getLowerCaseName(), PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural()), treeCrop.asItem(), arg);
            if (treeCrop.getTagCategory() != TagCategory.CROPS) {
                this.createCategoryTag(TagCategory.CROPS.getLowerCaseName(), PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural()), treeCrop.asItem(), arg);
            }
            if (treeCrop.getTagCategory() != TagCategory.NUTS) continue;
            this.createCategoryTag(TagCategory.FRUITS.getLowerCaseName(), PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural()), treeCrop.asItem(), arg);
        }
        for (Tree tree : Tree.copy()) {
            this.createCategoryTag(tree.getTagCategory().getLowerCaseName(), PluralInfo.plural(tree.getLowercaseName(), tree.hasPlural()), tree.asItem(), arg);
        }
    }

    protected void generateSeedsSaplings() {
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            if (farmlandCrop == Content.CHILE_PEPPER) {
                this.createSeedSaplingTag("seeds", "chilepepper", farmlandCrop.getSeedItem(), false);
                continue;
            }
            this.createSeedSaplingTag("seeds", farmlandCrop.getLowercaseName(), farmlandCrop.getSeedItem(), false);
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            this.createSeedSaplingTag("saplings", treeCrop.getLowercaseName(), treeCrop.getSaplingItem(), true);
        }
        for (Tree tree : Tree.copy()) {
            this.createSeedSaplingTag("saplings", tree.getLowercaseName(), tree.getSapling(), true);
        }
    }

    protected void generateOtherEnums(HolderLookup.Provider arg) {
        for (Seafood seafood : Seafood.copy()) {
            this.createGeneralTag(seafood.getPlural(), seafood.asItem());
        }
        for (Furnace furnace : Furnace.copy()) {
            this.createGeneralTag(furnace.getPlural(), furnace.asItem());
        }
        for (Juice juice : Juice.copy()) {
            this.createCategoryTag("juices", juice.name().toLowerCase() + "s", juice.asItem(), arg);
        }
        for (Jam jam : Jam.copy()) {
            this.createCategoryTag("jams", jam.name().toLowerCase() + "s", jam.asItem(), arg);
        }
        for (Smoothie smoothie : Smoothie.copy()) {
            this.createGeneralTag(smoothie.name().toLowerCase() + "s", smoothie.asItem());
        }
        for (IceCream iceCream : IceCream.copy()) {
            this.createGeneralTag(iceCream.name().toLowerCase() + "s", iceCream.asItem());
        }
        for (Pie pie : Pie.copy()) {
            this.createGeneralTag(pie.name().toLowerCase() + "s", pie.asItem());
        }
        for (Utensil utensil : Utensil.copy()) {
            this.createGeneralTag(utensil.getPlural(), utensil.asItem());
        }
    }

    protected void generateMisc() {
        this.createGeneralTag("almond_brittles", Content.ALMOND_BRITTLE);
        this.createGeneralTag("artichoke_dips", Content.ARTICHOKE_DIP);
        this.createGeneralTag("banana_cream_pies", Content.BANANA_CREAM_PIE);
        this.createGeneralTag("banana_nut_breads", Content.BANANA_NUT_BREAD);
        this.createGeneralTag("beef_jerkies", Content.BEEF_JERKY);
        this.createGeneralTag("beef_wellington", Content.BEEF_WELLINGTON);
        this.createGeneralTag("beers", Content.BEER);
        this.createGeneralTag("blts", Content.BLT);
        this.createGeneralTag("brownies", Content.BROWNIES);
        this.createGeneralTag("buttered_toasts", Content.BUTTERED_TOAST);
        this.createGeneralTag("butters", Content.BUTTER);
        this.createGeneralTag("caesar_salads", Content.CAESAR_SALAD);
        this.createGeneralTag("candied_nuts", Content.CANDIED_NUTS);
        this.createGeneralTag("candy_corns", Content.CANDY_CORN);
        this.createGeneralTag("cashew_chickens", Content.CASHEW_CHICKEN);
        this.createGeneralTag("cheese_cakes", Content.CHEESE_CAKE);
        this.createGeneralTag("cheese_pizzas", Content.CHEESE_PIZZA);
        this.createGeneralTag("cheeseburgers", Content.CHEESEBURGER);
        this.createGeneralTag("cheeses", Content.CHEESE);
        this.createGeneralTag("chicken_and_dumplings", Content.CHICKEN_AND_DUMPLINGS);
        this.createGeneralTag("chicken_and_noodles", Content.CHICKEN_AND_NOODLES);
        this.createGeneralTag("chicken_and_rice", Content.CHICKEN_AND_RICE);
        this.createGeneralTag("chocolate_milkshakes", Content.CHOCOLATE_MILKSHAKE);
        this.createGeneralTag("chocolates", Content.CHOCOLATE);
        this.createGeneralTag("coffees", Content.COFFEE);
        this.createGeneralTag("cornish_pasty", Content.CORNISH_PASTY);
        this.createGeneralTag("cucumber_salads", Content.CUCUMBER_SALAD);
        this.createGeneralTag("doughnuts", Content.DOUGHNUT);
        this.createGeneralTag("doughs", Content.DOUGH);
        this.createGeneralTag("egg_rolls", Content.EGG_ROLL);
        this.createGeneralTag("eton_mess", Content.ETON_MESS);
        this.createGeneralTag("figgy_pudding", Content.FIGGY_PUDDING);
        this.createGeneralTag("fish_and_chips", Content.FISH_AND_CHIPS);
        this.createGeneralTag("flour", Content.FLOUR);
        this.createGeneralTag("french_fries", Content.FRENCH_FRIES);
        this.createGeneralTag("fried_chickens", Content.FRIED_CHICKEN);
        this.createGeneralTag("fruit_salads", Content.FRUIT_SALAD);
        this.createGeneralTag("fruit_smoothies", Content.FRUIT_SMOOTHIE);
        this.createGeneralTag("grilled_cheeses", Content.GRILLED_CHEESE);
        this.createGeneralTag("ham_sandwiches", Content.HAM_SANDWICH);
        this.createGeneralTag("hamburgers", Content.HAMBURGER);
        this.createGeneralTag("kale_chips", Content.KALE_CHIPS);
        this.createGeneralTag("kale_smoothies", Content.KALE_SMOOTHIE);
        this.createGeneralTag("leafy_salads", Content.LEAFY_SALAD);
        this.createGeneralTag("leek_soups", Content.LEEK_SOUP);
        this.createGeneralTag("lemon_chickens", Content.LEMON_CHICKEN);
        this.createGeneralTag("lemonades", Content.LEMONADE);
        this.createGeneralTag("limeades", Content.LIMEADE);
        this.createGeneralTag("meads", Content.MEAD);
        this.createGeneralTag("milk_bottles", Content.MILK_BOTTLE);
        this.createGeneralTag("noodles", Content.NOODLE);
        this.createGeneralTag("nougats", Content.NOUGAT);
        this.createGeneralTag("nutty_cookies", Content.NUTTY_COOKIE);
        this.createGeneralTag("oatmeals", Content.OATMEAL);
        this.createGeneralTag("olive_oils", Content.OLIVE_OIL);
        this.createGeneralTag("onion_rings", Content.ONION_RINGS);
        this.createGeneralTag("paprika", Content.PAPRIKA);
        this.createGeneralTag("peanut_butter_and_jam", Content.PEANUT_BUTTER_AND_JAM);
        this.createGeneralTag("pepperoni", Content.PEPPERONI);
        this.createGeneralTag("pineapple_pepperoni_pizzas", Content.PINEAPPLE_PEPPERONI_PIZZA);
        this.createGeneralTag("pizzas", Content.PIZZA);
        this.createGeneralTag("pork_and_beanss", Content.PORK_AND_BEANS);
        this.createGeneralTag("pork_jerkies", Content.PORK_JERKY);
        this.createGeneralTag("potato_chips", Content.POTATO_CHIPS);
        this.createGeneralTag("protein_bars", Content.PROTEIN_BAR);
        this.createGeneralTag("pumpkin_spice_lattes", Content.PUMPKIN_SPICE_LATTE);
        this.createGeneralTag("raisin_oatmeal_cookies", Content.OATMEAL_COOKIE);
        this.createGeneralTag("ravioli", Content.RAVIOLI);
        this.createGeneralTag("roasted_nuts", Content.ROASTED_NUTS);
        this.createGeneralTag("rum_raisin_ice_creams", Content.RUM_RAISIN_ICE_CREAM);
        this.createGeneralTag("rums", Content.RUM);
        this.createGeneralTag("salsas", Content.SALSA);
        this.createGeneralTag("salt_ores", Content.SALT_ORE);
        this.createGeneralTag("saucy_chips", Content.SAUCY_CHIPS);
        this.createGeneralTag("scones", Content.SCONES);
        this.createGeneralTag("scrambled_eggs", Content.SCRAMBLED_EGGS);
        this.createGeneralTag("shepherds_pie", Content.SHEPHERDS_PIE);
        this.createGeneralTag("snicker_doodles", Content.SNICKER_DOODLE);
        this.createGeneralTag("soy_milks", Content.SOY_MILK);
        this.createGeneralTag("soy_sauces", Content.SOY_SAUCE);
        this.createGeneralTag("spaghetti_squashs", Content.SPAGHETTI_SQUASH);
        this.createGeneralTag("steamed_rices", Content.STEAMED_RICE);
        this.createGeneralTag("sticky_toffee_pudding", Content.STICKY_TOFFEE_PUDDING);
        this.createGeneralTag("supreme_pizzas", Content.SUPREME_PIZZA);
        this.createGeneralTag("sushis", Content.SUSHI);
        this.createGeneralTag("sweet_potato_friess", Content.SWEET_POTATO_FRIES);
        this.createGeneralTag("tacos", Content.TACO);
        this.createGeneralTag("tea", Content.TEA);
        this.createGeneralTag("toast_with_jam", Content.TOAST_WITH_JAM);
        this.createGeneralTag("tofu", Content.TOFU);
        this.createGeneralTag("tofu_and_dumplings", Content.TOFU_AND_DUMPLINGS);
        this.createGeneralTag("tofuburgers", Content.TOFUBURGER);
        this.createGeneralTag("tortillas", Content.TORTILLA);
        this.createGeneralTag("trail_mixes", Content.TRAIL_MIX);
        this.createGeneralTag("treacle_tarts", Content.TREACLE_TART);
        this.createGeneralTag("trifle", Content.TRIFLE);
        this.createGeneralTag("tuna_sandwiches", Content.TUNA_SANDWICH);
        this.createGeneralTag("veggie_salads", Content.VEGGIE_SALAD);
        this.createGeneralTag("wines", Content.WINE);
        this.createGeneralTag("yam_jam", Content.YAM_JAM);
        this.createGeneralTag("yoghurts", Content.YOGHURT);
        this.createGeneralTag("roasted_pumpkin_seeds", Content.ROASTED_PUMPKIN_SEEDS);
        this.createGeneralTag("roasted_sunflower_seeds", Content.ROASTED_SUNFLOWER_SEEDS);
        this.createGeneralTag("pumpkin_bars", Content.PUMPKIN_BARS);
        this.createGeneralTag("corn_breads", Content.CORN_BREAD);
        this.createGeneralTag("pumpkin_soups", Content.PUMPKIN_SOUP);
        this.createGeneralTag("meringue", Content.MERINGUE);
        this.createGeneralTag("cabbage_rolls", Content.CABBAGE_ROLL);
        this.createGeneralTag("borscht", Content.BORSCHT);
        this.createGeneralTag("goulashes", Content.GOULASH);
        this.createGeneralTag("beetroot_salads", Content.BEETROOT_SALAD);
        this.createGeneralTag("candied_kumquats", Content.CANDIED_KUMQUATS);
        this.createGeneralTag("steamed_crabs", Content.STEAMED_CRAB);
        this.createGeneralTag("sea_lettuce", Content.SEA_LETTUCE);
        this.createGeneralTag("deep_fried_shrimp", Content.DEEP_FRIED_SHRIMP);
        this.createGeneralTag("tuna_rolls", Content.TUNA_ROLL);
        this.createGeneralTag("fried_calamari", Content.FRIED_CALAMARI);
        this.createGeneralTag("crab_legs", Content.CRAB_LEGS);
        this.createGeneralTag("steamed_clams", Content.STEAMED_CLAMS);
        this.createGeneralTag("grilled_oysters", Content.GRILLED_OYSTERS);
        this.createGeneralTag("anchovy_pizzas", Content.ANCHOVY_PIZZA);
        this.createGeneralTag("mashed_potatoes", Content.MASHED_POTATOES);
        this.createGeneralTag("baked_crepes", Content.BAKED_CREPES);
        this.createGeneralTag("cinnamon_rolls", Content.CINNAMON_ROLL);
        this.createGeneralTag("croque_madame", Content.CROQUE_MADAME);
        this.createGeneralTag("croque_monsieur", Content.CROQUE_MONSIEUR);
        this.createGeneralTag("dauphine_potatoes", Content.DAUPHINE_POTATOES);
        this.createGeneralTag("fried_frog_legs", Content.FRIED_FROG_LEGS);
        this.createGeneralTag("frog_legs", Content.FROG_LEGS);
        this.createGeneralTag("ground_pork", Content.GROUND_PORK);
        this.createGeneralTag("hashed_brown", Content.HASHED_BROWN);
        this.createGeneralTag("macaron", Content.MACARON);
        this.createGeneralTag("quiche", Content.QUICHE);
        this.createGeneralTag("sausages", Content.SAUSAGE);
        this.createGeneralTag("sunny_side_eggs", Content.SUNNY_SIDE_EGGS);
        this.createGeneralTag("sweet_crepes", Content.SWEET_CREPES);
        this.createGeneralTag("the_big_breakfast", Content.THE_BIG_BREAKFAST);
        this.tag(CroptopiaIndependentItemTagProvider.register("water_bottles")).add((Object)Content.WATER_BOTTLE).add((Object)Items.WATER_BUCKET).addOptional(ResourceLocation.parse((String)"early_buckets:wooden_water_bucket"));
        this.tag(CroptopiaIndependentItemTagProvider.register("milks")).add((Object)Content.MILK_BOTTLE).add((Object)Content.SOY_MILK).add((Object)Items.MILK_BUCKET).addOptionalTag(this.independentTag("milk_buckets"));
        this.tag(CroptopiaIndependentItemTagProvider.register("potatoes")).add((Object)Items.POTATO).add((Object)Content.SWEETPOTATO.asItem());
    }

    private static TagKey<Item> register(String id) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)id));
    }

    private void createCategoryTag(String category, String name, Item item, HolderLookup.Provider arg) {
        String path = item.builtInRegistryHolder().key().location().getPath();
        TagKey<Item> forgeFriendlyTag = CroptopiaIndependentItemTagProvider.register(category + "/" + path);
        ResourceLocation independentEntry = this.independentTag(category + "/" + path);
        this.tag(forgeFriendlyTag).add((Object)item);
        this.tag(CroptopiaIndependentItemTagProvider.register(name)).add((Object)item).add(TagEntry.tag((ResourceLocation)independentEntry));
        ResourceLocation entryForGroup = this.independentTag(name);
        this.tag(CroptopiaIndependentItemTagProvider.register(category)).add(TagEntry.tag((ResourceLocation)entryForGroup));
    }

    private IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> createGeneralTag(String name, Item item) {
        TagKey<Item> pluralTag = CroptopiaIndependentItemTagProvider.register(name);
        FoodProperties foodProperties = (FoodProperties)item.components().get(DataComponents.FOOD);
        if (foodProperties != null) {
            this.tag(Tags.Items.FOODS).add((Object)item);
        }
        return this.tag(pluralTag).add((Object)item);
    }

    private void createSeedSaplingTag(String category, String name, Item item, boolean tree) {
        Object pluralSeedName = item == Content.VANILLA.getSeedItem() ? item.builtInRegistryHolder().key().location().getPath() : item.builtInRegistryHolder().key().location().getPath() + "s";
        TagKey<Item> forgeFriendlyTag = CroptopiaIndependentItemTagProvider.register(category + "/" + name);
        ResourceLocation independentEntry = this.independentTag(category + "/" + name);
        this.tag(forgeFriendlyTag).add((Object)item);
        this.tag(CroptopiaIndependentItemTagProvider.register(category)).add(TagEntry.tag((ResourceLocation)independentEntry));
        this.tag(CroptopiaIndependentItemTagProvider.register(name)).add((Object)item).add(TagEntry.tag((ResourceLocation)independentEntry));
        this.tag(CroptopiaIndependentItemTagProvider.register((String)pluralSeedName)).add((Object)item).add(TagEntry.tag((ResourceLocation)independentEntry));
    }

    private ResourceLocation independentTag(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)name);
    }
}

