/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AdditionalTableModifier
extends LootModifier {
    public static final Supplier<MapCodec<AdditionalTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> AdditionalTableModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.fieldOf("tableRef").forGetter(o -> o.tableID), (App)Codec.FLOAT.fieldOf("referChance").forGetter(o -> Float.valueOf(o.referChance)))).apply((Applicative)instance, AdditionalTableModifier::new)));
    private String tableID;
    private final NestedLootTable reference;
    private final float referChance;

    protected AdditionalTableModifier(LootItemCondition[] conditionsIn, String tableID, float chanceToRefer) {
        super(conditionsIn);
        this.referChance = chanceToRefer;
        this.tableID = tableID;
        ResourceKey croptopia = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"croptopia", (String)"gameplay/fishing/fish"));
        this.reference = (NestedLootTable)NestedLootTable.lootTableReference((ResourceKey)croptopia).build();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.getRandom().nextFloat() <= this.referChance) {
            ObjectArrayList items = new ObjectArrayList();
            this.reference.createItemStack(arg_0 -> ((ObjectArrayList)items).add(arg_0), context);
            return items;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

