/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;

public class Seafood
implements ItemConvertibleWithPlural {
    private static final List<Seafood> INSTANCES = new ArrayList<Seafood>();
    private final String name;
    private final boolean plural;
    private Item item;

    public Seafood(String name, boolean plural, FoodConstructor foodConstructor) {
        Content.ITEM_REGISTER.reg(registerFunction -> this.registerItem((RegisterFunction<Item>)registerFunction, foodConstructor));
        this.name = name;
        this.plural = plural;
        INSTANCES.add(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasPlural() {
        return this.plural;
    }

    public Item asItem() {
        return this.item;
    }

    public static List<Seafood> copy() {
        return INSTANCES;
    }

    public void registerItem(RegisterFunction<Item> register, FoodConstructor foodConstructor) {
        this.item = register.register(CroptopiaMod.createIdentifier(this.name), () -> {
            if (this.name.contains("GLOWING")) {
                return new Item(CroptopiaMod.createGroup().food(FoodConstructor.createBuilder(foodConstructor).effect(new MobEffectInstance(MobEffects.GLOWING, 4000, 1), 1.0f).build()));
            }
            return new Item(CroptopiaMod.createGroup().food(FoodConstructor.createFood(foodConstructor)));
        });
    }
}

