/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaSaplingBlock;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.MapColor;

public class Tree
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<Tree> TREES = new ArrayList<Tree>();
    private final String name;
    private final boolean hasPlural;
    private final TagCategory tagCategory;
    private Item item;
    private Block log;
    private Block strippedLog;
    private Block wood;
    private Block strippedWood;
    private final TagKey<Item> logItemTag;
    private final TagKey<Block> logBlockTag;
    private Block leaves;
    private ConfiguredFeature<TreeConfiguration, ?> treeGen;
    private Item sapling;
    private Block saplingBlock;
    private final ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey;
    private final ResourceKey<PlacedFeature> placedFeatureKey;

    public Tree(String name, boolean hasPlural, TagCategory category, int iTreeGen, int jTreeGen, int kTreeGen, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey, ResourceKey<PlacedFeature> placedFeatureKey) {
        Objects.requireNonNull(category);
        Content.BLOCK_REGISTER.reg(register -> {
            this.registerBlock((RegisterFunction<Block>)register);
            this.treeGen = Tree.createBarkGen(iTreeGen, jTreeGen, kTreeGen, this.log, this.leaves);
        });
        Content.ITEM_REGISTER.reg(this::registerItem);
        this.configuredFeatureKey = configuredFeatureKey;
        this.placedFeatureKey = placedFeatureKey;
        this.hasPlural = hasPlural;
        this.tagCategory = category;
        this.name = name;
        String tagName = name + "_logs";
        this.logItemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"croptopia", (String)tagName));
        this.logBlockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"croptopia", (String)tagName));
        TREES.add(this);
    }

    @Override
    public boolean hasPlural() {
        return this.hasPlural;
    }

    public TagCategory getTagCategory() {
        return this.tagCategory;
    }

    public Item asItem() {
        return this.item;
    }

    @Override
    public Block asBlock() {
        return this.log;
    }

    public Block getLog() {
        return this.log;
    }

    public Block getStrippedLog() {
        return this.strippedLog;
    }

    public Block getWood() {
        return this.wood;
    }

    public Block getStrippedWood() {
        return this.strippedWood;
    }

    public TagKey<Item> getLogItemTag() {
        return this.logItemTag;
    }

    public TagKey<Block> getLogBlockTag() {
        return this.logBlockTag;
    }

    public Block getLeaves() {
        return this.leaves;
    }

    public Item getSapling() {
        return this.sapling;
    }

    public Block getSaplingBlock() {
        return this.saplingBlock;
    }

    public ConfiguredFeature<TreeConfiguration, ?> getTreeGen() {
        return this.treeGen;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getConfiguredFeatureKey() {
        return this.configuredFeatureKey;
    }

    public ResourceKey<PlacedFeature> getPlacedFeatureKey() {
        return this.placedFeatureKey;
    }

    @Override
    public String name() {
        return this.name;
    }

    public static List<Tree> copy() {
        return TREES;
    }

    public void registerItem(RegisterFunction<Item> register) {
        this.item = register.register(CroptopiaMod.createIdentifier(this.name), () -> new Item(CroptopiaMod.createGroup()));
        register.register(CroptopiaMod.createIdentifier(this.name + "_log"), () -> new ItemNameBlockItem(this.log, CroptopiaMod.createGroup()));
        register.register(CroptopiaMod.createIdentifier("stripped_" + this.name + "_log"), () -> new ItemNameBlockItem(this.strippedLog, CroptopiaMod.createGroup()));
        register.register(CroptopiaMod.createIdentifier(this.name + "_wood"), () -> new ItemNameBlockItem(this.wood, CroptopiaMod.createGroup()));
        register.register(CroptopiaMod.createIdentifier("stripped_" + this.name + "_wood"), () -> new ItemNameBlockItem(this.strippedWood, CroptopiaMod.createGroup()));
        this.sapling = register.register(CroptopiaMod.createIdentifier(this.name + "_sapling"), () -> new ItemNameBlockItem(this.saplingBlock, CroptopiaMod.createGroup()));
    }

    public void registerBlock(RegisterFunction<Block> register) {
        this.log = register.register(CroptopiaMod.createIdentifier(this.name + "_log"), () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).ignitedByLava().sound(SoundType.WOOD).strength(2.0f)));
        this.strippedLog = register.register(CroptopiaMod.createIdentifier("stripped_" + this.name + "_log"), () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).ignitedByLava().sound(SoundType.WOOD).strength(2.0f)));
        this.wood = register.register(CroptopiaMod.createIdentifier(this.name + "_wood"), () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).ignitedByLava().sound(SoundType.WOOD).strength(2.0f)));
        this.strippedWood = register.register(CroptopiaMod.createIdentifier("stripped_" + this.name + "_wood"), () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).ignitedByLava().sound(SoundType.WOOD).strength(2.0f)));
        this.leaves = register.register(CroptopiaMod.createIdentifier(this.name + "_leaves"), CroptopiaMod::createRegularLeavesBlock);
        this.saplingBlock = register.register(CroptopiaMod.createIdentifier(this.name + "_sapling"), () -> new CroptopiaSaplingBlock(Tree.createTree(this.configuredFeatureKey), CroptopiaMod.createSaplingSettings().ignitedByLava()));
        CroptopiaMod.leafBlocks.add(this.leaves);
        CroptopiaMod.cropBlocks.add(this.saplingBlock);
    }

    private static TreeGrower createTree(ResourceKey<ConfiguredFeature<?, ?>> key) {
        return new TreeGrower(key.location().toString(), Optional.empty(), Optional.of(key), Optional.empty());
    }

    public static ConfiguredFeature<TreeConfiguration, ?> createBarkGen(int i, int j, int k, Block log, Block leaves) {
        return new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)SimpleStateProvider.simple((BlockState)log.defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(i, j, k), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)leaves.defaultBlockState(), 90).build()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines().build());
    }

    public static void attemptPop(BlockState state, UseOnContext context, BlockPos pos) {
        for (Tree crop : TREES) {
            if (!state.getBlock().equals(crop.getLog()) && !state.getBlock().equals(crop.getWood())) continue;
            Block.popResource((Level)context.getLevel(), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)crop.asItem()));
        }
    }
}

