/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleItemWhitelist;
import com.supermartijn642.trashcans.packet.PacketToggleLiquidWhitelist;
import com.supermartijn642.trashcans.screen.ArrowButton;
import com.supermartijn642.trashcans.screen.CheckBox;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanContainer;
import com.supermartijn642.trashcans.screen.WhitelistButton;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class UltimateTrashCanScreen
extends TrashCanScreen<UltimateTrashCanContainer> {
    private WhitelistButton itemWhitelistButton;
    private WhitelistButton liquidWhitelistButton;
    private CheckBox checkBox;
    private ArrowButton leftArrow;
    private ArrowButton rightArrow;
    private boolean shift;
    private boolean control;

    public UltimateTrashCanScreen() {
        super("trashcans.gui.ultimate_trash_can.title");
    }

    protected void addWidgets(TrashCanBlockEntity entity) {
        this.itemWhitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, this.height() - 185, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleItemWhitelist(((UltimateTrashCanContainer)this.container).getBlockEntityPos()))));
        this.itemWhitelistButton.update(entity.itemFilterWhitelist);
        this.liquidWhitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, this.height() - 155, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleLiquidWhitelist(((UltimateTrashCanContainer)this.container).getBlockEntityPos()))));
        this.liquidWhitelistButton.update(entity.liquidFilterWhitelist);
        this.checkBox = (CheckBox)this.addWidget((Widget)new CheckBox(21, 127, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleEnergyLimit(((UltimateTrashCanContainer)this.container).getBlockEntityPos()))));
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(49, 127, true, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((UltimateTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? -100000 : -100) : (this.control ? -10000 : -1000)))));
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(170, 127, false, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((UltimateTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? 100000 : 100) : (this.control ? 10000 : 1000)))));
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    protected void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderTooltips(context, mouseX, mouseY, (Object)entity);
        if (this.leftArrow.isFocused() && this.leftArrow.isActive()) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (String)("" + (this.shift ? (this.control ? -100000 : -100) : (this.control ? -10000 : -1000))), (int)mouseX, (int)mouseY);
        }
        if (this.rightArrow.isFocused() && this.rightArrow.isActive()) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (String)("+" + (this.shift ? (this.control ? 100000 : 100) : (this.control ? 10000 : 1000))), (int)mouseX, (int)mouseY);
        }
    }

    protected void update(TrashCanBlockEntity entity) {
        super.update((Object)entity);
        this.itemWhitelistButton.update(entity.itemFilterWhitelist);
        this.liquidWhitelistButton.update(entity.liquidFilterWhitelist);
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    @Override
    protected String getBackground() {
        return "ultimate_screen.png";
    }

    @Override
    protected void drawText(PoseStack poseStack, TrashCanBlockEntity entity) {
        ScreenUtils.drawString((PoseStack)poseStack, (Component)TextComponents.translation((String)"trashcans.gui.ultimate_trash_can.item_filter").get(), (float)8.0f, (float)53.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (Component)TextComponents.translation((String)"trashcans.gui.ultimate_trash_can.liquid_filter").get(), (float)8.0f, (float)83.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (Component)TextComponents.translation((String)"trashcans.gui.ultimate_trash_can.energy_limit").get(), (float)8.0f, (float)113.0f);
        ScreenUtils.drawCenteredString((PoseStack)poseStack, (Component)TextComponents.string((String)I18n.get((String)"trashcans.gui.energy_trash_can.value", (Object[])new Object[0]).replace("$number$", "" + entity.energyLimit)).get(), (float)114.0f, (float)132.0f);
    }

    protected boolean keyPressed(int keyCode, boolean hasBeenHandled, TrashCanBlockEntity object) {
        if (keyCode == 340) {
            this.shift = true;
        } else if (keyCode == 341) {
            this.control = true;
        }
        return super.keyPressed(keyCode, hasBeenHandled, (Object)object);
    }

    protected boolean keyReleased(int keyCode, boolean hasBeenHandled, TrashCanBlockEntity object) {
        if (keyCode == 340) {
            this.shift = false;
        } else if (keyCode == 341) {
            this.control = false;
        }
        return super.keyReleased(keyCode, hasBeenHandled, (Object)object);
    }
}

