/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.util;

import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Contract;

public enum RelativeBlockFace {
    FRONT,
    LEFT,
    BACK,
    RIGHT,
    UP,
    DOWN;

    public static final RelativeBlockFace[] HORIZONTAL;

    public Direction forFront(MultiblockOrientation orientation) {
        Direction front = orientation.front();
        boolean mirror = orientation.mirrored();
        Preconditions.checkArgument((boolean)front.getAxis().isHorizontal());
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> front;
            case 1 -> {
                if (mirror) {
                    yield front.getCounterClockWise();
                }
                yield front.getClockWise();
            }
            case 2 -> front.getOpposite();
            case 3 -> {
                if (mirror) {
                    yield front.getClockWise();
                }
                yield front.getCounterClockWise();
            }
            case 4 -> Direction.UP;
            case 5 -> Direction.DOWN;
        };
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static RelativeBlockFace from(MultiblockOrientation orientation, @Nullable Direction absoluteFace) {
        if (absoluteFace == null) {
            return null;
        }
        Direction front = orientation.front();
        boolean mirror = orientation.mirrored();
        Preconditions.checkArgument((boolean)front.getAxis().isHorizontal());
        if (absoluteFace == Direction.UP) {
            return UP;
        }
        if (absoluteFace == Direction.DOWN) {
            return DOWN;
        }
        int numRotations = Mth.positiveModulo((int)(front.get2DDataValue() - absoluteFace.get2DDataValue()), (int)4);
        return switch (numRotations) {
            case 0 -> FRONT;
            case 1 -> {
                if (mirror) {
                    yield LEFT;
                }
                yield RIGHT;
            }
            case 2 -> BACK;
            case 3 -> {
                if (mirror) {
                    yield RIGHT;
                }
                yield LEFT;
            }
            default -> throw new IllegalStateException("Unexpected value: " + numRotations);
        };
    }

    public BlockPos offsetRelative(BlockPos startPos, int amount) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> startPos.relative(Direction.NORTH, amount);
            case 1 -> startPos.relative(Direction.EAST, amount);
            case 2 -> startPos.relative(Direction.SOUTH, amount);
            case 3 -> startPos.relative(Direction.WEST, amount);
            case 4 -> startPos.above(amount);
            case 5 -> startPos.below(amount);
        };
    }

    public RelativeBlockFace getOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BACK;
            case 1 -> RIGHT;
            case 2 -> FRONT;
            case 3 -> LEFT;
            case 4 -> DOWN;
            case 5 -> UP;
        };
    }

    static {
        HORIZONTAL = new RelativeBlockFace[]{FRONT, LEFT, BACK, RIGHT};
    }
}

