/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;

public class TagUtils {
    private static List<ResourceLocation> getTags(Holder.Reference<?> ref) {
        return ref.tags().map(TagKey::location).toList();
    }

    public static Collection<ResourceLocation> getMatchingTagNames(RegistryAccess tags, ItemStack stack) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>(TagUtils.getTags(stack.getItem().builtInRegistryHolder()));
        Block b = Block.byItem((Item)stack.getItem());
        if (b != Blocks.AIR) {
            ret.addAll(TagUtils.getTags(b.builtInRegistryHolder()));
        }
        return ret;
    }

    public static String[] getMatchingPrefixAndRemaining(RegistryAccess tags, ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(tags, stack)) {
            for (String componentType : componentTypes) {
                if (!name.getPath().startsWith(componentType)) continue;
                String material = name.getPath().substring(componentType.length());
                if (material.startsWith("/")) {
                    material = material.substring(1);
                }
                if (material.length() <= 0) continue;
                return new String[]{componentType, material};
            }
        }
        return null;
    }

    public static boolean isIngot(RegistryAccess tags, ItemStack stack) {
        Registry registry = tags.registryOrThrow(Registries.ITEM);
        Optional tag = registry.getTag(Tags.Items.INGOTS);
        if (tag.isPresent()) {
            return ((HolderSet.Named)tag.get()).contains(Holder.direct((Object)stack.getItem()));
        }
        return false;
    }

    public static <T> Stream<T> elementStream(RegistryAccess tags, ResourceKey<Registry<T>> registry, ResourceLocation tag) {
        return TagUtils.holderStream(tags, registry, tag).map(Holder::value);
    }

    public static <T> Stream<T> elementStream(RegistryAccess tags, TagKey<T> key) {
        return TagUtils.holderStream(tags.registryOrThrow(key.registry()), key).map(Holder::value);
    }

    public static <T> Stream<T> elementStream(Registry<T> registry, TagKey<T> tag) {
        return TagUtils.holderStream(registry, tag).map(Holder::value);
    }

    public static <T> Stream<Holder<T>> holderStream(RegistryAccess tags, ResourceKey<Registry<T>> registry, ResourceLocation tag) {
        return TagUtils.holderStream(tags.registryOrThrow(registry), TagKey.create(registry, (ResourceLocation)tag));
    }

    public static <T> Stream<Holder<T>> holderStream(Registry<T> registry, TagKey<T> tag) {
        return StreamSupport.stream(registry.getTagOrEmpty(tag).spliterator(), false);
    }

    public static TagKey<Item> createItemWrapper(ResourceLocation name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)name);
    }

    public static TagKey<Block> createBlockWrapper(ResourceLocation name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)name);
    }

    public static TagKey<Fluid> createFluidWrapper(ResourceLocation name) {
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)name);
    }

    public static TagKey<EntityType<?>> createEntityWrapper(ResourceLocation name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)name);
    }

    public static TagKey<Biome> createBiomeWrapper(ResourceLocation name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)name);
    }
}

