/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;

public record ConnectionPoint(@Nonnull BlockPos position, int index) implements Comparable<ConnectionPoint>
{
    public static final DualCodec<ByteBuf, ConnectionPoint> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.BLOCK_POS.fieldOf("position"), ConnectionPoint::position, (DualMapCodec)DualCodecs.INT.fieldOf("index"), ConnectionPoint::index, ConnectionPoint::new);

    public ConnectionPoint(CompoundTag nbt) {
        this((BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"position").orElseThrow(), nbt.getInt("index"));
    }

    public CompoundTag createTag() {
        CompoundTag ret = new CompoundTag();
        ret.put("position", NbtUtils.writeBlockPos((BlockPos)this.position));
        ret.putInt("index", this.index);
        return ret;
    }

    @Override
    public int compareTo(ConnectionPoint o) {
        int blockCmp = this.position.compareTo((Vec3i)o.position);
        if (blockCmp != 0) {
            return blockCmp;
        }
        return Integer.compare(this.index, o.index);
    }

    public int getX() {
        return this.position.getX();
    }

    public int getY() {
        return this.position.getY();
    }

    public int getZ() {
        return this.position.getZ();
    }
}

