/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.MOD)
public class IEDefaultColourHandlers
implements ItemColor,
BlockColor {
    public static IEDefaultColourHandlers INSTANCE = new IEDefaultColourHandlers();

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item ev) {
        for (Holder itemRO : IEItems.REGISTER.getEntries()) {
            Item item = (Item)itemRO.value();
            if (!(item instanceof IEItemInterfaces.IColouredItem)) continue;
            ev.register((ItemColor)INSTANCE, new ItemLike[]{item});
        }
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block ev) {
        for (IEBlocks.BlockEntry<?> blockEntry : IEBlocks.BlockEntry.ALL_ENTRIES) {
            IEBlockInterfaces.IColouredBlock colouredBlock;
            Object block = blockEntry.get();
            if (!(block instanceof IEBlockInterfaces.IColouredBlock) || !(colouredBlock = (IEBlockInterfaces.IColouredBlock)block).hasCustomBlockColours()) continue;
            ev.register((BlockColor)INSTANCE, new Block[]{block});
        }
    }

    public int getColor(BlockState state, @Nullable BlockAndTintGetter worldIn, @Nullable BlockPos pos, int tintIndex) {
        Block block = state.getBlock();
        if (block instanceof IEBlockInterfaces.IColouredBlock) {
            IEBlockInterfaces.IColouredBlock colouredBlock = (IEBlockInterfaces.IColouredBlock)block;
            return colouredBlock.getRenderColour(state, (BlockGetter)worldIn, pos, tintIndex) | 0xFF000000;
        }
        return 0xFFFFFF;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        Item item = stack.getItem();
        if (item instanceof IEItemInterfaces.IColouredItem) {
            IEItemInterfaces.IColouredItem colouredItem = (IEItemInterfaces.IColouredItem)item;
            return colouredItem.getColourForIEItem(stack, tintIndex) | 0xFF000000;
        }
        return -1;
    }
}

