/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonLogicCircuitRegister;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.client.gui.elements.GuiSelectingList;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.gui.info.TooltipArea;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableBlockEntity;
import blusunrize.immersiveengineering.common.gui.CircuitTableMenu;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CircuitTableScreen
extends IEContainerScreen<CircuitTableMenu> {
    private static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("circuit_table");
    private EditBox name;
    private GuiSelectingList operatorList;
    private final List<GuiButtonLogicCircuitRegister> inputButtons = new ArrayList<GuiButtonLogicCircuitRegister>(LogicCircuitHandler.LogicCircuitOperator.TOTAL_MAX_INPUTS);
    private GuiButtonLogicCircuitRegister outputButton;
    private final Rect2i copyArea;
    private final ResettableLazy<Optional<LogicCircuitHandler.LogicCircuitInstruction>> instruction = new ResettableLazy<Optional>(() -> {
        LogicCircuitHandler.LogicCircuitOperator operator = this.getSelectedOperator();
        if (operator == null) {
            return Optional.empty();
        }
        LogicCircuitHandler.LogicCircuitRegister[] inputs = (LogicCircuitHandler.LogicCircuitRegister[])this.inputButtons.stream().map(GuiButtonState::getState).filter(Objects::nonNull).limit(operator.getArgumentCount()).toArray(LogicCircuitHandler.LogicCircuitRegister[]::new);
        if (inputs.length < operator.getArgumentCount()) {
            return Optional.empty();
        }
        return Optional.of(new LogicCircuitHandler.LogicCircuitInstruction(operator, (LogicCircuitHandler.LogicCircuitRegister)((Object)((Object)this.outputButton.getState())), inputs));
    });

    public CircuitTableScreen(CircuitTableMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageWidth = 234;
        this.imageHeight = 182;
        this.copyArea = new Rect2i(52, 7, 48, 63);
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 217, this.topPos + 26, (IEnergyStorage)((CircuitTableMenu)this.menu).energyStorage), (Object)new TooltipArea(this.copyArea, l -> {
            if (((CircuitTableMenu)this.menu).getCarried().getItem() instanceof LogicCircuitBoardItem) {
                l.add(TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.circuit_table.copy"), ChatFormatting.GRAY));
            }
        }));
    }

    @Override
    public void init() {
        super.init();
        this.operatorList = (GuiSelectingList)this.addRenderableWidget((GuiEventListener)new GuiSelectingList(this.leftPos + 58, this.topPos + 16, 36, 56, btn -> {
            this.minecraft.tell(this::updateButtons);
            this.minecraft.tell(this::updateInstruction);
        }, (String[])Arrays.stream(LogicCircuitHandler.LogicCircuitOperator.values()).map(Enum::name).toArray(String[]::new)).setPadding(1, 1, 2, 0));
        this.outputButton = (GuiButtonLogicCircuitRegister)this.addRenderableWidget((GuiEventListener)GuiButtonLogicCircuitRegister.create(this.leftPos + 121, this.topPos + 56, (Component)Component.translatable((String)"desc.immersiveengineering.info.circuit_table.btn.output"), btn -> this.minecraft.tell(this::updateInstruction)));
        this.name = new EditBox(this.font, this.leftPos + 172, this.topPos + 10, 54, 12, (Component)Component.translatable((String)"desc.immersiveengineering.info.circuit_table.field.name"));
        this.name.setCanLoseFocus(true);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setResponder(s -> this.updateInstruction());
        this.addRenderableWidget((GuiEventListener)this.name);
        this.updateButtons();
    }

    private LogicCircuitHandler.LogicCircuitInstruction getEditInstruction() {
        return (LogicCircuitHandler.LogicCircuitInstruction)((Slot)((CircuitTableMenu)this.menu).slots.get(CircuitTableBlockEntity.getEditSlot())).getItem().get(IEDataComponents.CIRCUIT_INSTRUCTION);
    }

    @Nullable
    private LogicCircuitHandler.LogicCircuitOperator getSelectedOperator() {
        LogicCircuitHandler.LogicCircuitInstruction editInstr = this.getEditInstruction();
        if (editInstr != null) {
            return editInstr.getOperator();
        }
        return LogicCircuitHandler.LogicCircuitOperator.getByString(this.operatorList.getSelectedString());
    }

    private void updateInstruction() {
        this.instruction.reset();
        this.instruction.get().ifPresentOrElse(instr -> {
            ((CircuitTableMenu)this.menu).instruction = instr;
            CompoundTag nbt = instr.serialize();
            String itemName = this.name.getValue();
            if (!itemName.isEmpty()) {
                nbt.putString("itemName", itemName);
            }
            this.sendUpdateToServer(nbt);
        }, () -> {
            ((CircuitTableMenu)this.menu).instruction = null;
            this.sendUpdateToServer(new CompoundTag());
        });
    }

    protected void slotClicked(Slot pSlot, int pSlotId, int pMouseButton, ClickType pType) {
        boolean editCircuit = pSlotId == CircuitTableBlockEntity.getEditSlot() || pType == ClickType.QUICK_MOVE && pSlotId >= ((CircuitTableMenu)this.menu).ownSlotCount && pSlot != null && pSlot.getItem().is((Item)IEItems.Misc.LOGIC_CIRCUIT_BOARD.get());
        super.slotClicked(pSlot, pSlotId, pMouseButton, pType);
        if (!editCircuit) {
            return;
        }
        ItemStack circuitStack = ((Slot)((CircuitTableMenu)this.menu).slots.get(CircuitTableBlockEntity.getEditSlot())).getItem();
        if (!circuitStack.isEmpty()) {
            this.minecraft.tell(this::updateButtons);
            this.minecraft.tell(this::updateInstruction);
            if (pSlot.getItem().has(DataComponents.CUSTOM_NAME)) {
                this.name.setValue(((Component)pSlot.getItem().get(DataComponents.CUSTOM_NAME)).getString());
            }
        }
    }

    private void updateButtons() {
        LogicCircuitHandler.LogicCircuitInstruction editInstr;
        LogicCircuitHandler.LogicCircuitOperator operator = this.getSelectedOperator();
        if (operator != null) {
            int inputCount = operator.getArgumentCount();
            int inputStart = 130 - (inputCount * 10 - 1);
            this.inputButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
            this.inputButtons.clear();
            for (int i = 0; i < inputCount; ++i) {
                this.inputButtons.add((GuiButtonLogicCircuitRegister)this.addRenderableWidget((GuiEventListener)GuiButtonLogicCircuitRegister.create(this.leftPos + inputStart + 20 * i, this.topPos + 18, (Component)Component.translatable((String)"desc.immersiveengineering.info.circuit_table.btn.input_num", (Object[])new Object[]{i + 1}), btn -> this.minecraft.tell(this::updateInstruction))));
            }
        }
        if ((editInstr = this.getEditInstruction()) != null) {
            this.operatorList.active = false;
            this.operatorList.setSelectedString(editInstr.getOperator().name());
            for (int i = 0; i < editInstr.getInputs().length; ++i) {
                this.inputButtons.get(i).setState(editInstr.getInputs()[i].ordinal());
            }
            this.outputButton.setState(editInstr.getOutput().ordinal());
        } else {
            this.operatorList.active = true;
        }
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            if (this.hoveredSlot.index < CircuitTableBlockEntity.getEditSlot()) {
                int slotNum = this.hoveredSlot.index;
                addGray.accept((Component)Component.translatable((String)("desc.immersiveengineering.info.circuit_table.slot." + CircuitTableBlockEntity.SLOT_TYPES[slotNum])));
            } else if (this.hoveredSlot.index == CircuitTableBlockEntity.getEditSlot()) {
                addGray.accept((Component)Component.translatable((String)"desc.immersiveengineering.info.circuit_table.slot.edit"));
            }
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.immersiveengineering.config.circuit_table.operator"), 76, 4, DyeColor.LIGHT_GRAY.getTextColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.immersiveengineering.config.circuit_table.inputs"), 130, 8, DyeColor.LIGHT_GRAY.getTextColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.immersiveengineering.config.circuit_table.outputs"), 130, 42, DyeColor.LIGHT_GRAY.getTextColor());
        for (int i = 0; i < CircuitTableBlockEntity.SLOT_TYPES.length; ++i) {
            int amount = 0;
            DyeColor col = DyeColor.LIGHT_GRAY;
            if (this.instruction.get().isPresent() && this.getEditInstruction() == null) {
                amount = CircuitTableBlockEntity.getIngredientAmount(this.instruction.get().get(), i);
                col = ((Slot)((CircuitTableMenu)this.menu).slots.get(i)).getItem().getCount() >= amount ? DyeColor.GREEN : DyeColor.RED;
            }
            graphics.drawString(this.font, "x " + amount, 30, 18 + 20 * i, col.getTextColor());
        }
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (this.name.isFocused() && key != 256 && (this.name.keyPressed(key, scancode, modifiers) || this.name.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (GuiButtonState guiButtonState : this.inputButtons) {
            if (!guiButtonState.isHoveredOrFocused()) continue;
            return guiButtonState.charTyped(codePoint, modifiers);
        }
        if (this.outputButton.isHoveredOrFocused()) {
            return this.outputButton.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        LogicCircuitHandler.LogicCircuitInstruction instr;
        if (this.isMouseIn((int)mouseX, (int)mouseY, 52, 7, 100, 70) && ((CircuitTableMenu)this.menu).getCarried().getItem() instanceof LogicCircuitBoardItem && (instr = (LogicCircuitHandler.LogicCircuitInstruction)((CircuitTableMenu)this.menu).getCarried().get(IEDataComponents.CIRCUIT_INSTRUCTION)) != null) {
            this.operatorList.setSelectedString(instr.getOperator().name());
            this.updateButtons();
            this.outputButton.setState(instr.getOutput().ordinal());
            LogicCircuitHandler.LogicCircuitRegister[] inputs = instr.getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                this.inputButtons.get(i).setState(inputs[i].ordinal());
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

