/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class FluorescentTubeCallbacks
implements ItemCallback<Key> {
    public static final FluorescentTubeCallbacks INSTANCE = new FluorescentTubeCallbacks();
    private static final List<List<String>> special = List.of(List.of("tube"));

    @Override
    public Key extractKey(ItemStack object, LivingEntity owner) {
        boolean lit = FluorescentTubeItem.isLit(object);
        float min = 0.3f + (lit ? ((FluorescentTubeItem.LitState)object.get(IEDataComponents.FLUORESCENT_TUBE_LIT)).strength() * 0.68f : 0.0f);
        float mult = min + (lit ? ApiUtils.RANDOM.nextFloat() * Mth.clamp((float)(1.0f - min), (float)0.0f, (float)0.1f) : 0.0f);
        float[] colors = FluorescentTubeItem.getRGBFloat(object, mult);
        return new Key(new Color4(colors[0], colors[1], colors[2], colors[3]));
    }

    @Override
    public List<List<String>> getSpecialGroups(ItemStack stack, ItemDisplayContext transform, LivingEntity entity) {
        return special;
    }

    @Override
    public boolean areGroupsFullbright(ItemStack stack, List<String> groups) {
        return groups.size() == 1 && "tube".equals(groups.get(0)) && FluorescentTubeItem.isLit(stack);
    }

    @Override
    public Color4 getRenderColor(Key object, String group, String material, ShaderCase shaderCase, Color4 original) {
        if ("tube".equals(group)) {
            return object.color();
        }
        return new Color4(0.067f, 0.067f, 0.067f, 1.0f);
    }

    @Override
    public Key getDefaultKey() {
        return new Key(new Color4(1, 1, 1, 1));
    }

    public record Key(Color4 color) {
    }
}

