/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.BlueprintRenderer;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class ModWorkbenchRenderer
extends IEBlockEntityRenderer<ModWorkbenchBlockEntity> {
    private static final Map<String, IVertexBufferHolder> VBO_BY_BLUEPRINT = new HashMap<String, IVertexBufferHolder>();

    public void render(ModWorkbenchBlockEntity te, float partialTicks, PoseStack transform, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isDummy() || !te.getLevelNonnull().hasChunkAt(te.getBlockPos())) {
            return;
        }
        transform.pushPose();
        transform.translate(0.5, 0.5, 0.5);
        Direction facing = te.getFacing();
        float angle = facing == Direction.NORTH ? 0.0f : (facing == Direction.WEST ? 1.5707964f : (facing == Direction.EAST ? -1.5707964f : (float)Math.PI));
        transform.mulPose(new Quaternionf().rotateY(angle));
        ItemStack stack = (ItemStack)te.getInventory().get(0);
        boolean showIngredients = true;
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof EngineersBlueprintItem) {
                ClientLevel level;
                List<RecipeHolder<BlueprintCraftingRecipe>> recipes;
                String category;
                double playerDistanceSq = ClientUtils.mc().player.distanceToSqr(Vec3.atCenterOf((Vec3i)te.getBlockPos()));
                if (playerDistanceSq < 120.0 && !(category = IEApiDataComponents.getBlueprintType(stack)).isEmpty() && !"invalid_blueprint".equals(category) && !(recipes = BlueprintCraftingRecipe.findRecipes((Level)(level = ClientUtils.mc().level), category)).isEmpty()) {
                    IVertexBufferHolder vbo = VBO_BY_BLUEPRINT.computeIfAbsent(category, this::buildVBO);
                    vbo.render(BlueprintRenderer.RENDER_TYPE, combinedLightIn, combinedOverlayIn, bufferIn, transform);
                }
            } else {
                showIngredients = false;
                transform.pushPose();
                transform.translate(0.0, 0.5625, 0.0);
                transform.mulPose(new Quaternionf().rotateY((float)Math.PI).rotateX(1.5707964f));
                transform.translate(-0.875, 0.0, 0.0);
                transform.scale(0.75f, 0.75f, 0.75f);
                ClientUtils.mc().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, transform, bufferIn, te.getLevel(), 0);
                transform.popPose();
            }
        }
        if (showIngredients) {
            for (int i = 1; i < te.getInventory().size(); ++i) {
                double dZ;
                double dX;
                if (i < 5) {
                    dX = -0.5 + (i == 2 ? -0.0625 : (i == 4 ? 0.03215 : 0.0));
                    dZ = (double)i * 0.25 - 0.625;
                } else {
                    dX = -1.25;
                    dZ = -0.125 + (double)(i - 5) * -0.25;
                }
                stack = (ItemStack)te.getInventory().get(i);
                if (stack.isEmpty()) continue;
                transform.pushPose();
                transform.mulPose(new Quaternionf().rotateY((float)Math.PI).rotateX(1.5707964f));
                transform.translate(dX, dZ, -0.515);
                transform.scale(0.25f, 0.25f, 0.25f);
                try {
                    ClientUtils.mc().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, transform, bufferIn, te.getLevel(), 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                transform.popPose();
            }
        }
        transform.popPose();
    }

    private IVertexBufferHolder buildVBO(String category) {
        return IVertexBufferHolder.create((builder, transform, light, overlay) -> {
            ClientLevel level = ClientUtils.mc().level;
            List<RecipeHolder<BlueprintCraftingRecipe>> recipes = BlueprintCraftingRecipe.findRecipes((Level)level, category);
            transform.pushPose();
            int numRecipes = Math.min(recipes.size(), 9);
            int perRow = numRecipes > 6 ? numRecipes - 3 : (numRecipes > 4 ? numRecipes - 2 : (numRecipes == 1 ? 2 : (numRecipes == 2 ? 3 : numRecipes)));
            transform.translate(0.0, 0.502, 0.0);
            transform.mulPose(new Quaternionf().rotateY(-0.3926991f).rotateX(-1.5707964f));
            transform.translate(0.39, numRecipes > 4 ? 0.72 : 0.78, 0.0);
            float scale = numRecipes > 4 ? 0.009375f : 0.012f;
            transform.scale(scale, -scale, scale);
            int rendered = 0;
            for (int i = 0; i < numRecipes; ++i) {
                BlueprintRenderer.BlueprintLines blueprint;
                BlueprintCraftingRecipe recipe = (BlueprintCraftingRecipe)recipes.get(i % recipes.size()).value();
                BlueprintRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : BlueprintRenderer.getBlueprintDrawable(recipe, (Level)level);
                if (blueprint == null) continue;
                double dX = rendered < perRow ? 0.93725 / (double)scale - (double)perRow * 16.6 + (double)rendered * 16.6 : 0.70375 / (double)scale - (double)(rendered % perRow) * 16.6;
                double dY = rendered < perRow ? 0.0 : -0.15625;
                transform.translate(dX, dY / (double)scale, 0.0);
                float texScale = (float)blueprint.textureScale / 16.0f;
                transform.scale(1.0f / texScale, 1.0f / texScale, 1.0f / texScale);
                blueprint.draw(transform, builder, light);
                transform.scale(texScale, texScale, texScale);
                transform.translate(-dX, -dY / (double)scale, 0.0);
                ++rendered;
            }
            transform.popPose();
        });
    }

    public AABB getRenderBoundingBox(ModWorkbenchBlockEntity workbench) {
        if (workbench.renderAABB == null) {
            workbench.renderAABB = new AABB(-1.0, 0.0, -1.0, 2.0, 2.0, 2.0).move(workbench.getBlockPos());
        }
        return workbench.renderAABB;
    }
}

