/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.metal.SampleDrillBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class SampleDrillRenderer
extends IEBlockEntityRenderer<SampleDrillBlockEntity> {
    public static final String NAME = "sample_drill";
    public static DynamicModel DRILL;

    public void render(SampleDrillBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getLevelNonnull().hasChunkAt(tile.getBlockPos())) {
            return;
        }
        BlockState state = tile.getLevelNonnull().getBlockState(tile.getBlockPos());
        if (state.getBlock() != IEBlocks.MetalDevices.SAMPLE_DRILL.get()) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        int max = (Integer)IEServerConfig.MACHINES.coredrill_time.get();
        if (tile.process > 0 && tile.process < max) {
            float currentProcess = tile.process;
            if (tile.isRunning) {
                currentProcess += partialTicks;
            }
            matrixStack.mulPose(new Quaternionf().rotateY(currentProcess * 22.5f % 360.0f * ((float)Math.PI / 180)));
            float push = (float)tile.process / (float)max;
            if (tile.process > max / 2) {
                push = 1.0f - push;
            }
            matrixStack.translate(0.0f, -2.8f * push, 0.0f);
        }
        matrixStack.translate(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = DRILL.getNullQuads();
        RenderUtils.renderModelTESRFast(quads, bufferIn.getBuffer(RenderType.solid()), matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.popPose();
    }

    public AABB getRenderBoundingBox(SampleDrillBlockEntity blockEntity) {
        if (blockEntity.renderAABB == null) {
            blockEntity.renderAABB = blockEntity.dummy == 0 ? new AABB(Vec3.ZERO, new Vec3(1.0, 3.0, 1.0)) : new AABB(Vec3.ZERO, Vec3.ZERO);
            blockEntity.renderAABB = blockEntity.renderAABB.move(blockEntity.getBlockPos());
        }
        return blockEntity.renderAABB;
    }
}

