/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEHangingSignBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IESignBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;

public class IESignBlocks {

    public static class WallHanging
    extends WallHangingSignBlock {
        public WallHanging(WoodType type, BlockBehaviour.Properties properties) {
            super(type, properties);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
            return WallHanging.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)IEBlockEntities.HANGING_SIGN.get()), SignBlockEntity::tick);
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new IEHangingSignBlockEntity(pos, state);
        }
    }

    public static class Hanging
    extends CeilingHangingSignBlock {
        public Hanging(WoodType type, BlockBehaviour.Properties properties) {
            super(type, properties);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
            return Hanging.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)IEBlockEntities.HANGING_SIGN.get()), SignBlockEntity::tick);
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new IEHangingSignBlockEntity(pos, state);
        }
    }

    public static class Wall
    extends WallSignBlock {
        public Wall(WoodType type, BlockBehaviour.Properties properties) {
            super(type, properties);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
            return Wall.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)IEBlockEntities.SIGN.get()), SignBlockEntity::tick);
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new IESignBlockEntity(pos, state);
        }
    }

    public static class Standing
    extends StandingSignBlock {
        public Standing(WoodType type, BlockBehaviour.Properties properties) {
            super(type, properties);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
            return Standing.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)IEBlockEntities.SIGN.get()), SignBlockEntity::tick);
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new IESignBlockEntity(pos, state);
        }
    }

    public record Holder(Standing standing) {
    }
}

