/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StripCurtainBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IAdvancedDirectionalBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IColouredBE,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IBlockBounds {
    @NotNull
    public Color4 colour = Color4.WHITE;
    private int redstoneSignal = 0;
    private boolean strongSignal = false;
    private static final AABB[] bounds = new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.1875, 0.0625), new AABB(0.0, 0.0, 0.9375, 1.0, 0.1875, 1.0), new AABB(0.0, 0.0, 0.0, 0.0625, 0.1875, 1.0), new AABB(0.9375, 0.0, 0.0, 1.0, 0.1875, 1.0), new AABB(0.0, 0.8125, 0.46875, 1.0, 1.0, 0.53125), new AABB(0.46875, 0.8125, 0.0, 0.53125, 1.0, 1.0)};
    private static final VoxelShape[] shapes = (VoxelShape[])Arrays.stream(bounds).map(Shapes::create).toArray(VoxelShape[]::new);

    public StripCurtainBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.STRIP_CURTAIN.get(), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.level.getGameTime() % 4L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 3)) {
            List entities = this.level.getEntitiesOfClass(Entity.class, this.getEntityCollectionBox());
            if (!this.isCeilingAttached() && !entities.isEmpty() && this.redstoneSignal == 0) {
                this.redstoneSignal = 15;
                this.sendRSUpdates();
            }
            if (entities.isEmpty() && this.redstoneSignal != 0) {
                this.redstoneSignal = 0;
                this.sendRSUpdates();
            }
        }
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (this.isCeilingAttached() && entity.isAlive() && this.redstoneSignal == 0 && entity.getBoundingBox().intersects(this.getEntityCollectionBox())) {
            this.redstoneSignal = 15;
            this.sendRSUpdates();
        }
    }

    private void sendRSUpdates() {
        this.setChanged();
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.level.updateNeighborsAt(this.getBlockPos().relative(this.getStrongSignalSide()), this.getBlockState().getBlock());
    }

    private Direction getStrongSignalSide() {
        if (this.isCeilingAttached()) {
            return Direction.UP;
        }
        return this.getFacing();
    }

    private AABB getEntityCollectionBox() {
        AABB aabb = bounds[this.isCeilingAttached() ? (this.getFacing().getAxis() == Direction.Axis.Z ? 4 : 5) : (this.getFacing().ordinal() - 2) % 4];
        return new AABB(aabb.minX, aabb.minY - 0.8125, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ).move(this.getBlockPos());
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        if (!this.strongSignal || side != this.getStrongSignalSide().getOpposite()) {
            return 0;
        }
        return this.getWeakRSOutput(side);
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return 0;
        }
        return this.redstoneSignal;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.colour = Color4.load(nbt.get("colour"));
        this.strongSignal = nbt.getBoolean("strongSignal");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.put("colour", this.colour.save());
        nbt.putBoolean("strongSignal", this.strongSignal);
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return shapes[this.isCeilingAttached() ? (this.getFacing().getAxis() == Direction.Axis.Z ? 4 : 5) : (this.getFacing().ordinal() - 2) % 4];
    }

    @Override
    @Nonnull
    public Property<Direction> getFacingProperty() {
        return StripCurtainBlock.FACING;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        this.setCeilingAttached(side == Direction.DOWN);
    }

    @Override
    public int getRenderColour(int tintIndex) {
        if (tintIndex == 1) {
            return this.colour.toInt();
        }
        return 0xFFFFFF;
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        stack.set(IEDataComponents.COLOR, (Object)this.colour);
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        this.colour = (Color4)stack.getOrDefault(IEDataComponents.COLOR, (Object)Color4.WHITE);
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.level.isClientSide) {
            this.strongSignal = !this.strongSignal;
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl.strongSignal." + this.strongSignal)), true);
            this.sendRSUpdates();
        }
        return ItemInteractionResult.SUCCESS;
    }

    public boolean isCeilingAttached() {
        return (Boolean)this.getBlockState().getValue((Property)StripCurtainBlock.CEILING_ATTACHED);
    }

    public void setCeilingAttached(boolean ceilingAttached) {
        BlockState newState = (BlockState)this.getBlockState().setValue((Property)StripCurtainBlock.CEILING_ATTACHED, (Comparable)Boolean.valueOf(ceilingAttached));
        this.getLevelNonnull().setBlockAndUpdate(this.worldPosition, newState);
    }
}

