/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Unit;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidPumpBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IScrewdriverInteraction,
IFluidPipe,
IEBlockInterfaces.IBlockOverlayText {
    public Map<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
    private final FluidTank tank;
    private final MutableEnergyStorage energyStorage;
    private boolean placeCobble;
    private final MultiblockCapability<IEnergyStorage> energyCap;
    public boolean redstoneControlInverted;
    private boolean checkingArea;
    private Fluid searchFluid;
    private final List<BlockPos> openList;
    private final List<BlockPos> closedList;
    private final Set<BlockPos> checked;
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IFluidHandler>> blockFluidHandlers;
    private final Map<Direction, IFluidHandler> sidedFluidHandler;

    public FluidPumpBlockEntity(BlockEntityType<FluidPumpBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            if (d == Direction.DOWN) {
                this.sideConfig.put(d, IEEnums.IOSideConfig.INPUT);
                continue;
            }
            this.sideConfig.put(d, IEEnums.IOSideConfig.NONE);
        }
        this.tank = new FluidTank(4000);
        this.energyStorage = new MutableEnergyStorage(8000);
        this.placeCobble = true;
        this.energyCap = MultiblockCapability.make(this, be -> be.energyCap, FluidPumpBlockEntity::master, this.makeEnergyInput(this.energyStorage));
        this.redstoneControlInverted = false;
        this.checkingArea = false;
        this.searchFluid = null;
        this.openList = new ArrayList<BlockPos>();
        this.closedList = new ArrayList<BlockPos>();
        this.checked = new HashSet<BlockPos>();
        this.blockFluidHandlers = IEBlockCapabilityCaches.allNeighbors(Capabilities.FluidHandler.BLOCK, this);
        this.sidedFluidHandler = new EnumMap<Direction, IFluidHandler>(Direction.class);
    }

    @Override
    public void tickServer() {
        if (this.isDummy()) {
            return;
        }
        if (this.tank.getFluidAmount() > 0) {
            int i = this.outputFluid(this.tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.tank.drain(i, IFluidHandler.FluidAction.EXECUTE);
        }
        int consumption = (Integer)IEServerConfig.MACHINES.pump_consumption.get();
        if (this.canRun()) {
            for (Direction f : Direction.values()) {
                if (this.sideConfig.get(f) != IEEnums.IOSideConfig.INPUT) continue;
                IFluidHandler input = this.blockFluidHandlers.get(f).getCapability();
                if (input == null) {
                    input = this.getEntityFluidHandler(f);
                }
                if (input != null) {
                    int drainAmount = IFluidPipe.getTransferableAmount(this.canOutputPressurized(false));
                    FluidStack drain = input.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
                    if (drain.isEmpty()) continue;
                    int out = this.outputFluid(drain, IFluidHandler.FluidAction.EXECUTE);
                    input.drain(out, IFluidHandler.FluidAction.EXECUTE);
                    continue;
                }
                this.gatherInfiniteFluidFromWorld(f);
            }
            if (this.level.getGameTime() % 40L == (long)(((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) % 40 + 40) % 40)) {
                if (this.closedList.isEmpty()) {
                    this.prepareAreaCheck();
                } else {
                    int target = this.closedList.size() - 1;
                    BlockPos pos = this.closedList.get(target);
                    FluidStack fs = Utils.drainFluidBlock(this.level, pos, IFluidHandler.FluidAction.SIMULATE);
                    if (fs == null) {
                        this.closedList.remove(target);
                    } else if (this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE) == fs.getAmount() && this.energyStorage.extractEnergy(consumption, true) >= consumption) {
                        this.energyStorage.extractEnergy(consumption, false);
                        fs = Utils.drainFluidBlock(this.level, pos, IFluidHandler.FluidAction.EXECUTE);
                        if (((Boolean)IEServerConfig.MACHINES.pump_placeCobble.get()).booleanValue() && this.placeCobble) {
                            this.level.setBlockAndUpdate(pos, Blocks.COBBLESTONE.defaultBlockState());
                        }
                        this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                        this.closedList.remove(target);
                    }
                }
            }
        }
        if (this.checkingArea) {
            this.checkAreaTick();
        }
    }

    private boolean canRun() {
        BlockEntity above;
        boolean isPowered = this.isRSPowered();
        if (!isPowered && (above = this.level.getBlockEntity(this.getBlockPos().above())) instanceof FluidPumpBlockEntity) {
            FluidPumpBlockEntity dummy = (FluidPumpBlockEntity)above;
            isPowered = dummy.isRSPowered();
        }
        return isPowered ^ this.redstoneControlInverted;
    }

    public void prepareAreaCheck() {
        this.openList.clear();
        this.closedList.clear();
        this.checked.clear();
        this.searchFluid = null;
        for (Direction f : Direction.values()) {
            if (this.sideConfig.get(f) != IEEnums.IOSideConfig.INPUT) continue;
            this.openList.add(this.getBlockPos().relative(f));
            this.checkingArea = true;
        }
    }

    private void gatherInfiniteFluidFromWorld(Direction gatherFrom) {
        if (this.level.getGameTime() % 20L != (long)Mth.positiveModulo((int)(this.getBlockPos().getX() ^ this.getBlockPos().getZ()), (int)20)) {
            return;
        }
        int consumption = (Integer)IEServerConfig.MACHINES.pump_consumption.get();
        if (this.energyStorage.extractEnergy(consumption, true) < consumption) {
            return;
        }
        BlockPos neighborPos = this.getBlockPos().relative(gatherFrom);
        FluidState neighborFluidState = this.level.getFluidState(neighborPos);
        if (!neighborFluidState.isSource() || !neighborFluidState.canConvertToSource(this.getLevelNonnull(), neighborPos)) {
            return;
        }
        Fluid fluid = neighborFluidState.getType();
        FluidStack gatheredFluid = new FluidStack(fluid, 1000);
        if (this.tank.fill(gatheredFluid, IFluidHandler.FluidAction.SIMULATE) != gatheredFluid.getAmount()) {
            return;
        }
        int connectedSources = 0;
        for (Direction sourceNeighbor : DirectionUtils.BY_HORIZONTAL_INDEX) {
            FluidState neighboringSource = this.level.getFluidState(neighborPos.relative(sourceNeighbor));
            if (neighboringSource.getType() != fluid || !neighboringSource.isSource()) continue;
            ++connectedSources;
        }
        if (connectedSources > 1) {
            this.energyStorage.extractEnergy(consumption, false);
            this.tank.fill(gatheredFluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void checkAreaTick() {
        int closedListMax = 2048;
        int timeout = 0;
        while (timeout < 64 && this.closedList.size() < 2048 && !this.openList.isEmpty()) {
            FluidState fluidState;
            ++timeout;
            BlockPos next = this.openList.remove(0);
            if (!this.checked.add(next) || (fluidState = this.getLevelNonnull().getFluidState(next)).isEmpty() || fluidState.canConvertToSource(this.getLevelNonnull(), next)) continue;
            Fluid fluid = fluidState.getType();
            if (this.searchFluid != null && fluid != this.searchFluid) continue;
            if (this.searchFluid == null) {
                this.searchFluid = fluid;
            }
            if (!Utils.drainFluidBlock(this.level, next, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                this.closedList.add(next);
            }
            for (Direction f : Direction.values()) {
                FluidState neighborFluidState;
                BlockPos neighborPos = next.relative(f);
                if (this.checked.contains(neighborPos) || (neighborFluidState = this.getLevelNonnull().getFluidState(neighborPos)).isEmpty()) continue;
                Fluid neighborFluid = Utils.getRelatedFluid(this.level, neighborPos);
                if (neighborFluidState.canConvertToSource(this.getLevelNonnull(), neighborPos) || neighborFluid != this.searchFluid) continue;
                this.openList.add(neighborPos);
            }
        }
        if (this.closedList.size() >= 2048 || this.openList.isEmpty()) {
            this.checkingArea = false;
        }
    }

    public int outputFluid(FluidStack fs, IFluidHandler.FluidAction action) {
        FluidStack insertResource;
        if (fs.isEmpty()) {
            return 0;
        }
        int canAccept = fs.getAmount();
        if (canAccept <= 0) {
            return 0;
        }
        int accelPower = (Integer)IEServerConfig.MACHINES.pump_consumption_accelerate.get();
        int fluidForSort = canAccept;
        int sum = 0;
        HashMap<FluidPipeBlockEntity.DirectionalFluidOutput, Integer> sorting = new HashMap<FluidPipeBlockEntity.DirectionalFluidOutput, Integer>();
        for (Direction f : Direction.values()) {
            FluidStack insertResource2;
            int temp;
            if (this.sideConfig.get(f) != IEEnums.IOSideConfig.OUTPUT) continue;
            IFluidHandler handler = this.blockFluidHandlers.get(f).getCapability();
            if (handler != null) {
                int temp2;
                BlockEntity tile = this.getLevelNonnull().getBlockEntity(this.worldPosition.relative(f));
                insertResource = Utils.copyFluidStackWithAmount(fs, fs.getAmount(), true);
                if (tile instanceof FluidPipeBlockEntity && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                    insertResource.set(IEApiDataComponents.FLUID_PRESSURIZED, (Object)Unit.INSTANCE);
                }
                if ((temp2 = handler.fill(insertResource, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                sorting.put(new FluidPipeBlockEntity.DirectionalFluidOutput(handler, f, tile, this.worldPosition.relative(f)), temp2);
                sum += temp2;
                continue;
            }
            handler = this.getEntityFluidHandler(f);
            if (handler == null || (temp = handler.fill(insertResource2 = Utils.copyFluidStackWithAmount(fs, fs.getAmount(), true), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            sorting.put(new FluidPipeBlockEntity.DirectionalFluidOutput(handler, f, null, this.worldPosition.relative(f)), temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            int i = 0;
            for (FluidPipeBlockEntity.DirectionalFluidOutput output : sorting.keySet()) {
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)fluidForSort * prio);
                if (i++ == sorting.size() - 1) {
                    amount = canAccept;
                }
                insertResource = Utils.copyFluidStackWithAmount(fs, amount, true);
                if (output.containingTile() instanceof FluidPipeBlockEntity && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                    this.energyStorage.extractEnergy(accelPower, false);
                    insertResource.set(IEApiDataComponents.FLUID_PRESSURIZED, (Object)Unit.INSTANCE);
                }
                int r = output.output().fill(insertResource, action);
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    @Nullable
    private IFluidHandler getEntityFluidHandler(Direction direction) {
        return this.level.getEntities(null, new AABB(this.getBlockPos().relative(direction))).stream().map(entity -> (IFluidHandler)entity.getCapability(Capabilities.FluidHandler.ENTITY, (Object)direction.getOpposite())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        int[] sideConfigArray = nbt.getIntArray("sideConfig");
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.VALUES[sideConfigArray[d.ordinal()]]);
        }
        if (nbt.contains("placeCobble", 1)) {
            this.placeCobble = nbt.getBoolean("placeCobble");
        }
        this.tank.readFromNBT(provider, nbt.getCompound("tank"));
        EnergyHelper.deserializeFrom(this.energyStorage, nbt, provider);
        this.redstoneControlInverted = nbt.getBoolean("redstoneInverted");
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        int[] sideConfigArray = new int[6];
        for (Direction d : DirectionUtils.VALUES) {
            sideConfigArray[d.ordinal()] = this.sideConfig.get(d).ordinal();
        }
        nbt.putIntArray("sideConfig", sideConfigArray);
        nbt.putBoolean("placeCobble", this.placeCobble);
        nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
        EnergyHelper.serializeTo(this.energyStorage, nbt, provider);
        nbt.putBoolean("redstoneInverted", this.redstoneControlInverted);
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, Player p) {
        if (side != Direction.UP && !this.isDummy()) {
            this.sideConfig.put(side, IEEnums.IOSideConfig.next(this.sideConfig.get(side)));
            this.setChanged();
            this.markContainingBlockForUpdate(null);
            this.getLevelNonnull().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 0);
            return true;
        }
        if (p.isShiftKeyDown()) {
            BlockEntity tmp;
            FluidPumpBlockEntity master = this;
            if (this.isDummy() && (tmp = this.level.getBlockEntity(this.worldPosition.below())) instanceof FluidPumpBlockEntity) {
                master = (FluidPumpBlockEntity)tmp;
            }
            master.placeCobble = !master.placeCobble;
            p.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.pump.placeCobble." + master.placeCobble)), true);
            return true;
        }
        return false;
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.isDummy()) {
            BlockEntity te = this.level.getBlockEntity(this.worldPosition.below());
            if (te instanceof FluidPumpBlockEntity) {
                FluidPumpBlockEntity master = (FluidPumpBlockEntity)te;
                return master.screwdriverUseSide(side, player, hand, hitVec);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.level.isClientSide) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<FluidPumpBlockEntity> registrar) {
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, facing) -> {
            if (facing != null && !be.isDummy()) {
                if (!be.sidedFluidHandler.containsKey(facing)) {
                    be.sidedFluidHandler.put((Direction)facing, new SidedFluidHandler((FluidPumpBlockEntity)be, (Direction)facing));
                }
                return be.sidedFluidHandler.get(facing);
            }
            return null;
        });
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, facing) -> facing == null || facing == Direction.UP && be.isDummy() ? be.energyCap.get() : null);
    }

    @Override
    public Component[] getOverlayText(@Nullable BlockState blockState, Player player, HitResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && !this.isDummy() && mop instanceof BlockHitResult) {
            BlockHitResult brtr = (BlockHitResult)mop;
            IEEnums.IOSideConfig i = this.sideConfig.get(brtr.getDirection());
            IEEnums.IOSideConfig j = this.sideConfig.get(brtr.getDirection().getOpposite());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", i, j);
        }
        return null;
    }

    public void setDummy(boolean dummy) {
        BlockState old = this.getBlockState();
        BlockState newState = (BlockState)old.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(dummy));
        this.setState(newState);
    }

    @Override
    public boolean isDummy() {
        return (Boolean)this.getBlockState().getValue((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Override
    @Nullable
    public FluidPumpBlockEntity master() {
        FluidPumpBlockEntity pump;
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.getBlockPos().below();
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return te instanceof FluidPumpBlockEntity ? (pump = (FluidPumpBlockEntity)te) : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        BlockPos dummyPos = this.worldPosition.above();
        this.getLevelNonnull().setBlockAndUpdate(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)), this.getLevelNonnull(), dummyPos));
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!Utils.isBlockAt(this.level, this.getBlockPos().offset(0, this.isDummy() ? -1 : 0, 0).offset(0, i, 0), IEBlocks.MetalDevices.FLUID_PUMP.get())) continue;
            this.level.removeBlock(this.getBlockPos().offset(0, this.isDummy() ? -1 : 0, 0).offset(0, i, 0), false);
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (!this.isDummy()) {
            return Shapes.block();
        }
        return Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        int accelPower = (Integer)IEServerConfig.MACHINES.pump_consumption_accelerate.get();
        if (this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
            if (consumePower) {
                this.energyStorage.extractEnergy(accelPower, false);
            }
            return true;
        }
        return false;
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        FluidPumpBlockEntity pump;
        Direction facing;

        SidedFluidHandler(FluidPumpBlockEntity pump, Direction facing) {
            this.pump = pump;
            this.facing = facing;
        }

        public int getTanks() {
            return this.pump.tank.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.pump.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.pump.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            if (this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT) {
                return false;
            }
            return this.pump.tank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT) {
                return 0;
            }
            return this.pump.tank.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drain(resource.getAmount(), action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            return this.pump.tank.drain(maxDrain, action);
        }
    }
}

