/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.IESounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TurretChemBlockEntity
extends TurretBlockEntity<TurretChemBlockEntity> {
    public static final int TANK_VOLUME = 4000;
    public FluidTank tank = new FluidTank(4000);
    public boolean ignite = false;
    private final IFluidHandler tankCap = this.makeFluidInput(new IFluidTank[]{this.tank});

    public TurretChemBlockEntity(BlockEntityType<TurretChemBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected double getRange() {
        return 8.0;
    }

    @Override
    protected boolean canActivate() {
        return this.tank.getFluidAmount() > 0 && this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.turret_chem_consumption.get();
    }

    @Override
    protected int getChargeupTicks() {
        return 10;
    }

    @Override
    protected int getActiveTicks() {
        return 1;
    }

    @Override
    protected boolean loopActivation() {
        return true;
    }

    @Override
    protected void activate() {
        FluidStack fs = this.tank.getFluid().copy();
        if (!fs.isEmpty()) {
            int consumed = (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
            int energy = (Integer)IEServerConfig.MACHINES.turret_chem_consumption.get();
            if (consumed <= fs.getAmount() && this.energyStorage.extractEnergy(energy, true) >= energy) {
                this.tank.drain(consumed, IFluidHandler.FluidAction.EXECUTE);
                this.energyStorage.extractEnergy(energy, false);
                Vec3 v = this.getGunToTargetVec(this.target).normalize();
                int split = 8;
                boolean isGas = fs.getFluid().is(Tags.Fluids.GASEOUS);
                float scatter = isGas ? 0.15f : 0.05f;
                float range = isGas ? 0.5f : 1.0f;
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && this.ignite;
                FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer(this.level);
                for (int i = 0; i < split; ++i) {
                    Vec3 vecDir = v.add(ApiUtils.RANDOM.nextGaussian() * (double)scatter, ApiUtils.RANDOM.nextGaussian() * (double)scatter, ApiUtils.RANDOM.nextGaussian() * (double)scatter);
                    Vec3 throwerPos = this.getGunPosition();
                    ChemthrowerShotEntity chem = new ChemthrowerShotEntity(this.level, throwerPos.x + v.x * 0.875, throwerPos.y + v.y * 0.875, throwerPos.z + v.z * 0.875, fs);
                    chem.setOwner((Entity)fakePlayer);
                    chem.setDeltaMovement(vecDir.scale((double)range));
                    if (ignite) {
                        chem.igniteForSeconds(10.0f);
                    }
                    if (this.level.isClientSide) continue;
                    this.level.addFreshEntity((Entity)chem);
                }
                if (this.tick % 4 == 0) {
                    if (ignite) {
                        this.level.playSound(null, this.getBlockPos(), (SoundEvent)IESounds.sprayFire.value(), SoundSource.BLOCKS, 0.5f, 1.5f);
                    } else {
                        this.level.playSound(null, this.getBlockPos(), (SoundEvent)IESounds.spray.value(), SoundSource.BLOCKS, 0.5f, 0.75f);
                    }
                }
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        if (!descPacket) {
            this.tank.readFromNBT(provider, nbt.getCompound("tank"));
            this.ignite = nbt.getBoolean("ignite");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        if (!descPacket) {
            nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
            nbt.putBoolean("ignite", this.ignite);
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<TurretChemBlockEntity> registrar) {
        TurretBlockEntity.registerCapabilitiesBase(registrar);
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, facing) -> {
            if (!(be.isDummy() || facing != null && facing != Direction.DOWN && facing != be.getFacing().getOpposite())) {
                return be.tankCap;
            }
            return null;
        });
    }

    @Override
    public IEMenuTypes.ArgContainer<TurretChemBlockEntity, ?> getContainerType() {
        return IEMenuTypes.CHEM_TURRET;
    }
}

