/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.ChunkLoaderMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.ChunkLoaderShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.items.IItemHandler;

public class ChunkLoaderLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final TicketController TICKET_CONTROLLER = new TicketController(ResourceLocation.fromNamespaceAndPath((String)"immersiveengineering", (String)"resonanz_observer"), (serverLevel, ticketHelper) -> {
        for (Map.Entry check : ticketHelper.getBlockTickets().entrySet()) {
            MultiblockBlockEntityMaster mb;
            Object patt1$temp;
            boolean stillValid = false;
            BlockEntity patt0$temp = serverLevel.getBlockEntity((BlockPos)check.getKey());
            if (patt0$temp instanceof MultiblockBlockEntityMaster && (patt1$temp = (mb = (MultiblockBlockEntityMaster)patt0$temp).getHelper().getState()) instanceof State) {
                State chunkLoaderState = (State)patt1$temp;
                boolean bl = stillValid = chunkLoaderState.refreshTimer > 0;
            }
            if (stillValid) continue;
            ticketHelper.removeAllTickets((BlockPos)check.getKey());
        }
    });
    public static final int ENERGY_CAPACITY = 32000;
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(2, 1, 1, RelativeBlockFace.LEFT);
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 2);
    private static final CapabilityPosition INPUT_POS = new CapabilityPosition(0, 1, 1, RelativeBlockFace.RIGHT);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        if (!(context.getLevel().getRawLevel() instanceof ServerLevel)) {
            return;
        }
        State state = context.getState();
        int energy_required = (Integer)IEServerConfig.MACHINES.resonanz_observer_consumption.get();
        if (state.rsState.isEnabled(context) && state.energy.extractEnergy(energy_required, true) == energy_required) {
            if (state.refreshTimer > 0) {
                --state.refreshTimer;
            }
            if (state.refreshTimer <= 0) {
                if (!state.inventory.getStackInSlot(0).isEmpty()) {
                    state.inventory.getStackInSlot(0).shrink(1);
                    state.energy.extractEnergy(energy_required, false);
                    state.refreshTimer = 20 * (Integer)IEServerConfig.MACHINES.resonanz_observer_paper_duration.get();
                    this.forceChunks(context, true);
                } else {
                    this.forceChunks(context, false);
                }
            }
        } else if (state.refreshTimer > 0) {
            state.refreshTimer = 0;
            this.forceChunks(context, false);
        }
        boolean wasActive = state.renderAsActive;
        boolean bl = state.renderAsActive = state.refreshTimer > 0;
        if (wasActive != state.renderAsActive) {
            context.requestMasterBESync();
        }
    }

    private void forceChunks(IMultiblockContext<State> ctx, boolean add) {
        BlockPos masterPos = ctx.getLevel().toAbsolute(ChunkLoaderMultiblock.MASTER_OFFSET);
        Level level = ctx.getLevel().getRawLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkLoaderLogic.getChunks(masterPos).forEach(chunk -> TICKET_CONTROLLER.forceChunk(serverLevel, masterPos, chunk.x, chunk.z, add, true));
        }
    }

    private static Stream<ChunkPos> getChunks(BlockPos masterPos) {
        int blockRadius = (Integer)IEServerConfig.MACHINES.resonanz_observer_radius.get();
        int minX = SectionPos.blockToSectionCoord((int)(masterPos.getX() - blockRadius));
        int maxX = SectionPos.blockToSectionCoord((int)(masterPos.getX() + blockRadius));
        int minZ = SectionPos.blockToSectionCoord((int)(masterPos.getZ() - blockRadius));
        int maxZ = SectionPos.blockToSectionCoord((int)(masterPos.getZ() + blockRadius));
        return IntStream.range(minX, maxX).boxed().flatMap(x -> IntStream.range(minZ, maxZ).mapToObj(z -> new ChunkPos(x.intValue(), z)));
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
    }

    @Override
    public void onRemoved(IMultiblockContext<State> context) {
        this.forceChunks(context, false);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAt(Capabilities.ItemHandler.BLOCK, INPUT_POS, state -> state.input);
        register.registerAt(Capabilities.EnergyStorage.BLOCK, ENERGY_INPUT, state -> state.energy);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems(state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return ChunkLoaderShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        public final SlotwiseItemHandler inventory;
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public int refreshTimer = 0;
        public boolean renderAsActive;
        private final IItemHandler input;

        public State(IInitialMultiblockContext<State> ctx) {
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(new SlotwiseItemHandler.IOConstraint(true, i -> i.is(IETags.paper)), 1)), ctx.getMarkDirtyRunnable());
            this.input = new WrappingItemHandler((IItemHandler)this.inventory, true, false);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.putInt("refreshTimer", this.refreshTimer);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.energy.deserializeNBT(provider, (Tag)nbt.getCompound("energy"));
            this.refreshTimer = nbt.getInt("refreshTimer");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("renderAsActive", this.renderAsActive);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.renderAsActive = nbt.getBoolean("renderAsActive");
        }

        public Stream<BlockEntity> getNearbyBlockEntities(IMultiblockContext<State> ctx) {
            BlockPos masterPos = ctx.getLevel().toAbsolute(ChunkLoaderMultiblock.MASTER_OFFSET);
            Level level = ctx.getLevel().getRawLevel();
            Stream<ChunkPos> chunks = ChunkLoaderLogic.getChunks(masterPos);
            return chunks.flatMap(pos -> level.getChunk(pos.x, pos.z).getBlockEntities().values().stream()).filter(blockEntity -> !masterPos.equals((Object)blockEntity.getBlockPos()) && blockEntity.getBlockState().getTicker(level, blockEntity.getType()) != null);
        }
    }
}

