/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.generic.AnyFacingEntityBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.BlueprintShelfBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlueprintShelfBlock
extends AnyFacingEntityBlock<BlueprintShelfBlockEntity> {
    public static final BooleanProperty[] BLUEPRINT_SLOT_FILLED = new BooleanProperty[9];
    private static final EnumMap<Direction, VoxelShape> SHAPES = new EnumMap(Direction.class);

    public BlueprintShelfBlock(BlockBehaviour.Properties blockProps) {
        super(IEBlockEntities.BLUEPRINT_SHELF, blockProps);
        BlockState defaultState = (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IEProperties.FACING_ALL, (Comparable)Direction.NORTH);
        for (BooleanProperty booleanProperty : BLUEPRINT_SLOT_FILLED) {
            defaultState = (BlockState)defaultState.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(defaultState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add((Property[])BLUEPRINT_SLOT_FILLED);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)IEProperties.FACING_ALL));
    }

    static {
        for (int i = 0; i < BLUEPRINT_SLOT_FILLED.length; ++i) {
            BlueprintShelfBlock.BLUEPRINT_SLOT_FILLED[i] = BooleanProperty.create((String)("blueprint_" + i));
        }
        for (Direction d : Direction.values()) {
            SHAPES.put(d, Block.box((double)(d == Direction.WEST ? 3.0 : 0.0), (double)0.0, (double)(d == Direction.NORTH ? 3.0 : 0.0), (double)(d == Direction.EAST ? 13.0 : 16.0), (double)(d == Direction.UP ? 13.0 : 16.0), (double)(d == Direction.SOUTH ? 13.0 : 16.0)));
        }
    }
}

