/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class DamageToolRecipe
extends ShapelessRecipe {
    public DamageToolRecipe(String group, ItemStack result, Ingredient tool, NonNullList<Ingredient> input) {
        super(group, CraftingBookCategory.MISC, result, DamageToolRecipe.addTo(tool, input));
    }

    private static NonNullList<Ingredient> addTo(Ingredient additional, NonNullList<Ingredient> old) {
        old.add((Object)additional);
        return old;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList remains = super.getRemainingItems((RecipeInput)inv);
        for (int i = 0; i < remains.size(); ++i) {
            ItemStack s = inv.getItem(i);
            ItemStack remain = (ItemStack)remains.get(i);
            ItemStack tool = ItemStack.EMPTY;
            int toolDamageSlot = this.getIngredients().size() - 1;
            if (remain.isEmpty() && !s.isEmpty() && ((Ingredient)this.getIngredients().get(toolDamageSlot)).test(s)) {
                tool = s.copy();
            } else if (!remain.isEmpty() && ((Ingredient)this.getIngredients().get(toolDamageSlot)).test(remain)) {
                tool = remain;
            }
            if (tool.isEmpty() || !tool.isDamageableItem()) continue;
            tool.setDamageValue(tool.getDamageValue() + 1);
            if (tool.getDamageValue() > tool.getMaxDamage()) {
                tool = ItemStack.EMPTY;
            }
            remains.set(i, (Object)tool);
        }
        return remains;
    }

    public boolean matches(CraftingInput matrix, Level world) {
        LinkedList required = new LinkedList(this.getIngredients());
        for (int i = 0; i < matrix.size(); ++i) {
            ItemStack slot = matrix.getItem(i);
            if (slot.isEmpty()) continue;
            boolean inRecipe = false;
            Iterator iterator = required.iterator();
            while (iterator.hasNext()) {
                Ingredient next = (Ingredient)iterator.next();
                if (!next.test(slot)) continue;
                inRecipe = true;
                iterator.remove();
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.DAMAGE_TOOL_SERIALIZER.get();
    }

    public Ingredient getTool() {
        return (Ingredient)this.getIngredients().get(this.getIngredients().size() - 1);
    }
}

