/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.items.components.AttachedItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PowerpackRecipe
implements CraftingRecipe {
    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput inv, @Nonnull Level world) {
        ItemStack powerpack = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (powerpack.isEmpty() && stackInSlot.is(IEItems.Misc.POWERPACK.asItem())) {
                powerpack = stackInSlot;
                continue;
            }
            if (armor.isEmpty() && this.isValidArmor(stackInSlot)) {
                armor = stackInSlot;
                continue;
            }
            return false;
        }
        if (armor.isEmpty()) {
            return false;
        }
        return armor.has(IEDataComponents.CONTAINED_POWERPACK) == powerpack.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        ItemStack powerpack = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (powerpack.isEmpty() && stackInSlot.is(IEItems.Misc.POWERPACK.asItem())) {
                powerpack = stackInSlot;
                continue;
            }
            if (!armor.isEmpty() || !this.isValidArmor(stackInSlot)) continue;
            armor = stackInSlot;
        }
        if (!powerpack.isEmpty() && !armor.has(IEDataComponents.CONTAINED_POWERPACK)) {
            ItemStack output = armor.copy();
            output.set(IEDataComponents.CONTAINED_POWERPACK, (Object)new AttachedItem(powerpack.copyWithCount(1)));
            return output;
        }
        if (armor.has(IEDataComponents.CONTAINED_POWERPACK)) {
            ItemStack output = armor.copy();
            output.remove(IEDataComponents.CONTAINED_POWERPACK);
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider access) {
        return new ItemStack(IEItems.Misc.POWERPACK, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList remaining = super.getRemainingItems((RecipeInput)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            AttachedItem powerpack = (AttachedItem)stackInSlot.get(IEDataComponents.CONTAINED_POWERPACK);
            if (powerpack == null) continue;
            remaining.set(i, (Object)powerpack.attached().copy());
        }
        return remaining;
    }

    private boolean isValidArmor(ItemStack stack) {
        ArmorItem armor;
        Item item = stack.getItem();
        if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).getEquipmentSlot() != EquipmentSlot.CHEST) {
            return false;
        }
        if (stack.getItem() == IEItems.Misc.POWERPACK.asItem()) {
            return false;
        }
        return !stack.is(IETags.powerpackForbidAttach);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.POWERPACK_SERIALIZER.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.withSize((int)1, (Object)Ingredient.of((ItemLike[])new ItemLike[]{IEItems.Misc.POWERPACK}));
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }
}

