/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class IEMinecartEntity<T extends BlockEntity>
extends AbstractMinecart
implements MenuProvider {
    private static final EntityDataAccessor<CompoundTag> DATA_ID_BE_DATA = SynchedEntityData.defineId(IEMinecartEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    protected T containedBlockEntity = (BlockEntity)this.getTileProvider().get();

    protected IEMinecartEntity(EntityType<?> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    protected IEMinecartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected abstract Supplier<T> getTileProvider();

    public T getContainedBlockEntity() {
        return this.containedBlockEntity;
    }

    public abstract void writeTileToItem(ItemStack var1);

    public abstract void readTileFromItem(LivingEntity var1, ItemStack var2);

    @Nonnull
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.CHEST;
    }

    public void destroy(@Nonnull DamageSource source) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemstack = this.getPickResult();
            this.writeTileToItem(itemstack);
            if (this.hasCustomName()) {
                itemstack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            this.spawnAtLocation(itemstack);
        }
    }

    public int getComparatorLevel() {
        if (this.containedBlockEntity instanceof IEBlockInterfaces.IComparatorOverride) {
            return ((IEBlockInterfaces.IComparatorOverride)this.containedBlockEntity).getComparatorInputOverride();
        }
        return super.getComparatorLevel();
    }

    @Nonnull
    public InteractionResult interact(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult superResult = super.interact(player, hand);
        if (superResult == InteractionResult.SUCCESS) {
            return superResult;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            T t = this.containedBlockEntity;
            if (t instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)t;
                if (menuProvider instanceof IEBlockInterfaces.IInteractionObjectIE) {
                    serverPlayer.openMenu((MenuProvider)this, buffer -> buffer.writeInt(this.getId()));
                } else {
                    serverPlayer.openMenu((MenuProvider)this);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_BE_DATA, (Object)new CompoundTag());
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.containedBlockEntity != null) {
            CompoundTag bEntityData = this.containedBlockEntity.saveWithoutMetadata((HolderLookup.Provider)this.level().registryAccess());
            compound.merge(bEntityData);
        }
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.containedBlockEntity = (BlockEntity)this.getTileProvider().get();
        this.containedBlockEntity.loadCustomOnly(compound, (HolderLookup.Provider)this.level().registryAccess());
        this.updateSynchedData();
    }

    public void updateSynchedData() {
        this.getEntityData().set(DATA_ID_BE_DATA, (Object)this.containedBlockEntity.saveWithoutMetadata((HolderLookup.Provider)this.level().registryAccess()));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_38527_) {
        super.onSyncedDataUpdated(p_38527_);
        if (DATA_ID_BE_DATA.equals(p_38527_)) {
            this.containedBlockEntity.loadCustomOnly((CompoundTag)this.getEntityData().get(DATA_ID_BE_DATA), (HolderLookup.Provider)this.level().registryAccess());
        }
    }

    protected Item getDropItem() {
        return Items.MINECART;
    }

    public static interface MinecartConstructor {
        public IEMinecartEntity<?> make(Level var1, double var2, double var4, double var6);
    }
}

