/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SorterMenu
extends IEContainerMenu {
    public final Map<Direction, GetterAndSetter<SorterBlockEntity.FilterConfig>> filterMasks;
    public final List<GetterAndSetter<Optional<ResourceLocation>>> selectedTags;

    public static SorterMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, SorterBlockEntity be) {
        Map<Direction, GetterAndSetter<SorterBlockEntity.FilterConfig>> filters = Arrays.stream(Direction.values()).map(d -> Pair.of((Object)d, new GetterAndSetter<SorterBlockEntity.FilterConfig>(() -> be.sideFilter.get(d), f -> be.sideFilter.put((Direction)d, (SorterBlockEntity.FilterConfig)f)))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        List<GetterAndSetter<Optional<ResourceLocation>>> selectedTag = IntStream.range(0, 48).mapToObj(slot -> new GetterAndSetter<Optional>(() -> Optional.ofNullable(be.filter.getSelectedTag(slot)), resourceLocation -> be.filter.setSelectedTag(slot, resourceLocation.orElse(null)))).toList();
        return new SorterMenu(SorterMenu.blockCtx(type, id, be), invPlayer, (IItemHandler)be.filter, filters, selectedTag);
    }

    public static SorterMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        Map<Direction, GetterAndSetter<SorterBlockEntity.FilterConfig>> filters = Arrays.stream(Direction.values()).map(d -> Pair.of((Object)d, GetterAndSetter.standalone(SorterBlockEntity.FilterConfig.DEFAULT))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        List<GetterAndSetter<Optional<ResourceLocation>>> selectedTag = IntStream.range(0, 48).mapToObj(slot -> GetterAndSetter.standalone(Optional.ofNullable(null))).toList();
        return new SorterMenu(SorterMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(48), filters, selectedTag);
    }

    private SorterMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler filter, Map<Direction, GetterAndSetter<SorterBlockEntity.FilterConfig>> filterMasks, List<GetterAndSetter<Optional<ResourceLocation>>> selectedTags) {
        super(ctx);
        int i;
        this.filterMasks = filterMasks;
        this.selectedTags = selectedTags;
        for (int side = 0; side < 6; ++side) {
            for (int j = 0; j < 8; ++j) {
                int x = 4 + side / 2 * 58 + (j < 3 ? j * 18 : (j > 4 ? (j - 5) * 18 : (j == 3 ? 0 : 36)));
                int y = 22 + side % 2 * 76 + (j < 3 ? 0 : (j > 4 ? 36 : 18));
                int id = side * 8 + j;
                this.addSlot((Slot)new IESlot.ItemHandlerGhost(filter, id, x, y));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 163 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 221));
        }
        for (Direction d : Direction.values()) {
            this.addGenericData(new GenericContainerData<SorterBlockEntity.FilterConfig>(GenericDataSerializers.FILTER_CONFIG, filterMasks.get(d)));
        }
        for (GetterAndSetter getterAndSetter : selectedTags) {
            this.addGenericData(new GenericContainerData<Optional<ResourceLocation>>(GenericDataSerializers.OPTIONAL_RESOURCE_LOCATION, getterAndSetter));
        }
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag message) {
        if (message.contains("sideConfigId", 3)) {
            SorterBlockEntity.FilterConfig filter = (SorterBlockEntity.FilterConfig)SorterBlockEntity.FilterConfig.CODEC.fromNBT(message.get("sideConfigVal"));
            this.filterMasks.get(Direction.values()[message.getInt("sideConfigId")]).set(filter);
        } else if (message.contains("tagSlot", 3)) {
            ResourceLocation selected = ResourceLocation.parse((String)message.getString("selectedTag"));
            this.selectedTags.get(message.getInt("tagSlot")).set(Optional.of(selected));
        }
    }
}

