/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.render.entity.ShaderMinecartRenderer;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageMinecartShaderSync(int entityID, Optional<ResourceLocation> shader) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageMinecartShaderSync> ID = IMessage.createType("minecart_shader_sync");
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageMinecartShaderSync> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageMinecartShaderSync::entityID, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), MessageMinecartShaderSync::shader, MessageMinecartShaderSync::new);

    @Override
    public void process(IPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            Level world = context.player().level();
            context.enqueueWork(() -> {
                Entity entity = world.getEntity(this.entityID);
                if (!(entity instanceof AbstractMinecart)) {
                    return;
                }
                CapabilityShader.ShaderWrapper cap = (CapabilityShader.ShaderWrapper)entity.getData(IEDataAttachments.MINECART_SHADER);
                if (cap != null) {
                    PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)world), (CustomPacketPayload)new MessageMinecartShaderSync(entity.getId(), Optional.ofNullable(cap.getShader())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        } else {
            context.enqueueWork(() -> {
                Entity entity;
                Level world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (entity = world.getEntity(this.entityID)) instanceof AbstractMinecart) {
                    ShaderMinecartRenderer.shadedCarts.put(this.entityID, (Object)this.shader.orElse(null));
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

