/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.mixin.accessors.client.ChatComponentAccess;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageNoSpamChat(Component message) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageNoSpamChat> ID = IMessage.createType("no_spam_chat");
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageNoSpamChat> CODEC = ComponentSerialization.TRUSTED_STREAM_CODEC.map(MessageNoSpamChat::new, MessageNoSpamChat::message);

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            ChatComponent chat = Minecraft.getInstance().gui.getChat();
            ChatComponentAccess chatAccess = (ChatComponentAccess)chat;
            List<GuiMessage> allMessages = chatAccess.getAllMessages();
            allMessages.removeIf(guiMessage -> Objects.equals(guiMessage.signature(), ChatUtils.NO_SPAM_SIGNATURE));
            chatAccess.invokeRefreshTrimmedMessages();
            chat.addMessage(this.message, ChatUtils.NO_SPAM_SIGNATURE, null);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

