/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.blocks.CrateItem;
import blusunrize.immersiveengineering.common.network.MessageIncognitoSync;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredRegister;

public class IEPotions {
    public static final DeferredRegister<MobEffect> REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.MOB_EFFECT, (String)"immersiveengineering");
    public static final Holder<MobEffect> FLAMMABLE = REGISTER.register("flammable", () -> new IEPotion(MobEffectCategory.HARMFUL, 9387807, 0, false, 0, true, true));
    public static final Holder<MobEffect> SLIPPERY = REGISTER.register("slippery", () -> new IEPotion(MobEffectCategory.HARMFUL, 1511427, 0, false, 1, true, true));
    public static final Holder<MobEffect> CONDUCTIVE = REGISTER.register("conductive", () -> new IEPotion(MobEffectCategory.HARMFUL, 0x690000, 0, false, 2, true, true));
    public static final Holder<MobEffect> STICKY = REGISTER.register("sticky", () -> new IEPotion(MobEffectCategory.HARMFUL, 10250240, 0, false, 3, true, true).addAttributeModifier(Attributes.MOVEMENT_SPEED, IEApi.ieLoc("sticky_movement"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> STUNNED = REGISTER.register("stunned", () -> new IEPotion(MobEffectCategory.HARMFUL, 6441624, 0, false, 4, true, true));
    public static final Holder<MobEffect> CONCRETE_FEET = REGISTER.register("concrete_feet", () -> new IEPotion(MobEffectCategory.HARMFUL, 6441624, 0, false, 5, true, true).addAttributeModifier(Attributes.MOVEMENT_SPEED, IEApi.ieLoc("concrete_feet_movement"), -2.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> FLASHED = REGISTER.register("flashed", () -> new IEPotion(MobEffectCategory.HARMFUL, 6441624, 0, false, 6, true, true).addAttributeModifier(Attributes.MOVEMENT_SPEED, IEApi.ieLoc("flashed_movement"), -0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> INCOGNITO = REGISTER.register("incognito", () -> new IEPotion(MobEffectCategory.BENEFICIAL, 6441624, 0, false, 6, true, true).addAttributeModifier(Attributes.KNOCKBACK_RESISTANCE, IEApi.ieLoc("incognito"), 1.0, AttributeModifier.Operation.ADD_VALUE));

    public static class IEPotion
    extends MobEffect {
        final int tickrate;
        final boolean halfTickRateWIthAmplifier;
        public final boolean showInInventory;
        public final boolean showInHud;

        public IEPotion(MobEffectCategory isBad, int colour, int tick, boolean halveTick, int icon, boolean showInInventory, boolean showInHud) {
            super(isBad, colour);
            this.showInInventory = showInInventory;
            this.showInHud = showInHud;
            this.tickrate = tick;
            this.halfTickRateWIthAmplifier = halveTick;
        }

        public boolean isDurationEffectTick(int duration, int amplifier) {
            if (this.tickrate < 0) {
                return false;
            }
            int k = this.tickrate >> amplifier;
            return k <= 0 || duration % k == 0;
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return this == SLIPPERY.value() || this == CONCRETE_FEET.value() || this == INCOGNITO.value();
        }

        public boolean applyEffectTick(LivingEntity living, int amplifier) {
            if (this == SLIPPERY.value()) {
                EquipmentSlot hand;
                if (living.onGround()) {
                    living.moveRelative(0.0f, new Vec3(0.0, 1.0, 0.005));
                }
                EquipmentSlot equipmentSlot = hand = living.getRandom().nextBoolean() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                if (!living.level().isClientSide && living.getRandom().nextInt(300) == 0 && !living.getItemBySlot(hand).isEmpty()) {
                    ItemEntity dropped = living.spawnAtLocation(living.getItemBySlot(hand).copy(), 1.0f);
                    dropped.setPickUpDelay(20);
                    living.setItemSlot(hand, ItemStack.EMPTY);
                }
            } else {
                if (this == CONCRETE_FEET.value() && !living.level().isClientSide) {
                    BlockState state = living.level().getBlockState(living.blockPosition());
                    return state.is(IETags.concreteForFeet);
                }
                if (!(this != INCOGNITO.value() || living.isCrouching() && living.getDeltaMovement().x == 0.0 && living.getDeltaMovement().z == 0.0 && living.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof CrateItem)) {
                    if (!living.level().isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MessageIncognitoSync(living.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    return false;
                }
            }
            return true;
        }
    }
}

