/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;

public class LayeredComparatorOutput<CTX> {
    private final double maxValue;
    private final int numLayers;
    private final double layerSize;
    private final ObjIntConsumer<CTX> updateMaster;
    private final LayerUpdater<CTX> updateLayer;
    private double lastValue = -1.0;
    private int currentMasterOutput;
    private final int[] currentLayerOutputs;

    public LayeredComparatorOutput(double maxValue, int numLayers, ObjIntConsumer<CTX> updateMaster, LayerUpdater<CTX> updateLayer) {
        this.maxValue = maxValue;
        this.numLayers = numLayers;
        this.updateMaster = updateMaster;
        this.updateLayer = updateLayer;
        this.currentMasterOutput = 0;
        this.currentLayerOutputs = new int[numLayers];
        this.layerSize = maxValue / (double)numLayers;
    }

    public static LayeredComparatorOutput<IMultiblockContext<?>> makeForSiloLike(int maxSize, int numLayers) {
        BlockPos masterPos = new BlockPos(1, 0, 1);
        static interface Updater {
            public void update(IMultiblockContext<?> var1, BlockPos var2, int var3);
        }
        Updater update = (ctx, pos, value) -> {
            IMultiblockLevel level = ctx.getLevel();
            ctx.setComparatorOutputFor(pos, value);
            BlockPos absPos = level.toAbsolute(masterPos);
            BlockState stateAt = level.getBlockState(masterPos);
            level.getRawLevel().updateNeighborsAt(absPos, stateAt.getBlock());
        };
        return new LayeredComparatorOutput(maxSize, numLayers, (ctx, value) -> update.update((IMultiblockContext<?>)ctx, masterPos, value), (ctx, layer, value) -> {
            for (int x = 0; x <= 2; ++x) {
                for (int z = 0; z <= 2; ++z) {
                    if (x == 1 && z == 1) continue;
                    update.update((IMultiblockContext<?>)ctx, new BlockPos(x, layer, z), value);
                }
            }
        });
    }

    public void update(CTX ctx, double newValue) {
        if (newValue == this.lastValue) {
            return;
        }
        this.lastValue = newValue;
        int newMasterOutput = (int)(15.0 * newValue / this.maxValue);
        if (this.currentMasterOutput != newMasterOutput) {
            this.currentMasterOutput = newMasterOutput;
            this.updateMaster.accept(ctx, newMasterOutput);
        }
        for (int layer = 0; layer < this.numLayers; ++layer) {
            double layerValue = newValue - (double)layer * this.layerSize;
            int newLayerOutput = (int)Mth.clamp((double)(15.0 * layerValue / this.layerSize), (double)0.0, (double)15.0);
            if (newLayerOutput == this.currentLayerOutputs[layer]) continue;
            this.currentLayerOutputs[layer] = newLayerOutput;
            this.updateLayer.update(ctx, layer, newLayerOutput);
        }
    }

    public int getCurrentMasterOutput() {
        return this.currentMasterOutput;
    }

    public int getLayerOutput(int layer) {
        return this.currentLayerOutputs[layer];
    }

    public static interface LayerUpdater<CTX> {
        public void update(CTX var1, int var2, int var3);
    }
}

