/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.entities.SkyhookUserData;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkylineHelper {
    private static final double LN_0_98 = Math.log(0.98);

    public static void spawnHook(LivingEntity player, Connection connection, InteractionHand hand, boolean limitSpeed, float slopeModifier) {
        if (!player.level().isClientSide) {
            GlobalWireNetwork global = GlobalWireNetwork.getNetwork(player.level());
            ConnectionPoint cpA = connection.getEndA();
            ConnectionPoint cpB = connection.getEndB();
            IImmersiveConnectable iicB = global.getExistingConnector(cpB);
            IImmersiveConnectable iicA = global.getExistingConnector(cpA);
            Vec3 vStart = Vec3.atLowerCornerOf((Vec3i)cpA.position());
            Vec3 vEnd = Vec3.atLowerCornerOf((Vec3i)cpB.position());
            if (iicB != null) {
                vStart = vStart.add(iicB.getConnectionOffset(cpB, cpA, connection.type));
            }
            if (iicA != null) {
                vEnd = vEnd.add(iicA.getConnectionOffset(cpA, cpB, connection.type));
            }
            Vec3 pos = player.getEyePosition(0.0f);
            Vec3 across = new Vec3(vEnd.x - vStart.x, vEnd.y - vStart.y, vEnd.z - vStart.z);
            double linePos = WireUtils.getCoeffForMinDistance(pos, vStart, across);
            Connection.CatenaryData catData = connection.getCatenaryData();
            Vec3 playerMovement = new Vec3(player.getDeltaMovement().x, player.getDeltaMovement().y, player.getDeltaMovement().z);
            double slopeAtPos = connection.getSlope(linePos, cpA);
            Vec3 extendedWire = catData.isVertical() ? new Vec3(0.0, catData.horLength(), 0.0) : new Vec3(catData.getDeltaX(), slopeAtPos * catData.horLength(), catData.getDeltaZ());
            extendedWire = extendedWire.normalize();
            double totalSpeed = playerMovement.dot(extendedWire);
            double horSpeed = totalSpeed / (Math.sqrt(1.0 + slopeAtPos * slopeAtPos) * (double)slopeModifier);
            SkylineHookEntity hook = new SkylineHookEntity(player.level(), connection, cpA, linePos, hand, horSpeed, limitSpeed, slopeModifier);
            IELogger.logger.info("Speed keeping: Player {}, wire {}, Pos: {}", (Object)playerMovement, (Object)extendedWire, (Object)hook.position());
            if (hook.isValidPosition(hook.getX(), hook.getY(), hook.getZ(), player)) {
                double vertSpeed = Math.sqrt(totalSpeed * totalSpeed - horSpeed * horSpeed);
                double speedDiff = player.getDeltaMovement().y - vertSpeed;
                if (speedDiff < 0.0) {
                    float fallDamageMod = 0.4f;
                    player.causeFallDamage(SkylineHelper.fallDistanceFromSpeed(speedDiff), fallDamageMod, player.damageSources().fall());
                    player.fallDistance = 0.0f;
                }
                player.level().addFreshEntity((Entity)hook);
                SkyhookUserData data = (SkyhookUserData)player.getData(IEDataAttachments.SKYHOOK_USER.get());
                data.startRiding();
                data.hook = hook;
                player.startRiding((Entity)hook);
                IELogger.logger.debug("Started riding");
            } else {
                IELogger.logger.debug("Invalid pos");
            }
        }
    }

    public static float fallDistanceFromSpeed(double v) {
        double fallTime = Math.log(v / 3.92 + 1.0) / LN_0_98;
        return -((float)(196.0 - 3.92 * fallTime - 194.04 * Math.pow(0.98, fallTime - 0.5)));
    }

    public static List<VoxelShape> getCollisionBoxes(@Nullable Entity entityIn, AABB aabb, Level w, Collection<BlockPos> ignored) {
        ArrayList list = Lists.newArrayList();
        SkylineHelper.getBlockCollisionBoxes(entityIn, aabb, list, w, ignored);
        w.getBlockCollisions(entityIn, aabb).forEach(list::add);
        return list;
    }

    public static void getBlockCollisionBoxes(final @Nullable Entity entityIn, AABB aabb, @Nonnull List<VoxelShape> outList, final Level w, final Collection<BlockPos> ignored) {
        int minX = Mth.floor((double)(aabb.minX - 1.0E-7)) - 1;
        int maxX = Mth.floor((double)(aabb.maxX + 1.0E-7)) + 1;
        int minY = Mth.floor((double)(aabb.minY - 1.0E-7)) - 1;
        int maxY = Mth.floor((double)(aabb.maxY + 1.0E-7)) + 1;
        int minZ = Mth.floor((double)(aabb.minZ - 1.0E-7)) - 1;
        int maxZ = Mth.floor((double)(aabb.maxZ + 1.0E-7)) + 1;
        final CollisionContext selectionCtx = entityIn == null ? CollisionContext.empty() : CollisionContext.of((Entity)entityIn);
        final Cursor3D it = new Cursor3D(minX, minY, minZ, maxX, maxY, maxZ);
        final BlockPos.MutableBlockPos currPos = new BlockPos.MutableBlockPos();
        final VoxelShape searchShape = Shapes.create((AABB)aabb);
        StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean isEntityNull;
            {
                super(arg0, arg1);
                this.isEntityNull = entityIn == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> add) {
                VoxelShape blockShapeWithOffset;
                if (!this.isEntityNull) {
                    assert (entityIn != null);
                    this.isEntityNull = true;
                    VoxelShape worldBorder = w.getWorldBorder().getCollisionShape();
                    boolean veryOutside = Shapes.joinIsNotEmpty((VoxelShape)worldBorder, (VoxelShape)Shapes.create((AABB)entityIn.getBoundingBox().deflate(1.0E-7)), (BooleanOp)BooleanOp.AND);
                    boolean nearlyOutside = Shapes.joinIsNotEmpty((VoxelShape)worldBorder, (VoxelShape)Shapes.create((AABB)entityIn.getBoundingBox().inflate(1.0E-7)), (BooleanOp)BooleanOp.AND);
                    if (!veryOutside && nearlyOutside) {
                        add.accept((VoxelShape)worldBorder);
                        return true;
                    }
                }
                while (true) {
                    VoxelShape blockShape;
                    int chunkZ;
                    int chunkX;
                    BlockGetter iblockreader;
                    if (!it.advance()) {
                        return false;
                    }
                    int currX = it.nextX();
                    int currY = it.nextY();
                    int currZ = it.nextZ();
                    int numBounderies = it.getNextType();
                    if (numBounderies == 3 || (iblockreader = w.getChunkForCollisions(chunkX = currX >> 4, chunkZ = currZ >> 4)) == null) continue;
                    currPos.set(currX, currY, currZ);
                    BlockState blockstate = iblockreader.getBlockState((BlockPos)currPos);
                    if (!(numBounderies == 1 && !blockstate.hasLargeCollisionShape() || numBounderies == 2 && blockstate.getBlock() != Blocks.MOVING_PISTON || ignored.contains(currPos) || !Shapes.joinIsNotEmpty((VoxelShape)searchShape, (VoxelShape)(blockShapeWithOffset = (blockShape = blockstate.getCollisionShape((BlockGetter)w, (BlockPos)currPos, selectionCtx)).move((double)currX, (double)currY, (double)currZ)), (BooleanOp)BooleanOp.AND))) break;
                }
                add.accept((VoxelShape)blockShapeWithOffset);
                return true;
            }
        }, false).forEach(outList::add);
    }
}

