/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.cokeoven;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class CokeOvenRecipeCategory
extends IERecipeCategory<CokeOvenRecipe> {
    private final IDrawableStatic tankOverlay;
    private final IDrawableAnimated flame;
    private static final int TANK_SIZE = 12000;

    public CokeOvenRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.COKE_OVEN, "block.immersiveengineering.coke_oven");
        ResourceLocation background = IEApi.ieLoc("textures/gui/coke_oven.png");
        this.setBackground(helper.createDrawable(background, 26, 16, 123, 55));
        this.setIcon(IEMultiblockLogic.COKE_OVEN.iconStack());
        this.tankOverlay = helper.createDrawable(background, 178, 33, 16, 47);
        this.flame = helper.drawableBuilder(background, 177, 0, 14, 14).buildAnimated(500, IDrawableAnimated.StartDirection.TOP, true);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, CokeOvenRecipe recipe, IFocusGroup focuses) {
        int batchSize = recipe.input.getCount();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 4, 19).addItemStacks(recipe.input.getMatchingStackList())).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"desc.immersiveengineering.info.batched", (Object[])new Object[]{batchSize}).withStyle(ChatFormatting.GOLD)));
        IRecipeSlotBuilder outputSlotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 19);
        if (!recipe.output.get().isEmpty()) {
            outputSlotBuilder.addItemStack(recipe.output.get());
        }
        if (recipe.creosoteOutput > 0) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 4).setFluidRenderer(12000L, false, 16, 47).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack((Fluid)IEFluids.CREOSOTE.getStill(), recipe.creosoteOutput))).addRichTooltipCallback(JEIHelper.fluidTooltipCallback);
        }
    }

    public void onDisplayedIngredientsUpdate(@Nonnull RecipeHolder<CokeOvenRecipe> recipe, @Nonnull List<IRecipeSlotDrawable> recipeSlots, @Nonnull IFocusGroup focuses) {
        long now = System.currentTimeMillis();
        long index = now / 1000L % 100000L;
        int batchSize = ((CokeOvenRecipe)recipe.value()).input.getCount();
        int qty = 1 + Math.toIntExact(index) % batchSize;
        IRecipeSlotDrawable inputSlot = recipeSlots.getFirst();
        inputSlot.createDisplayOverrides().addItemStacks(inputSlot.getItemStacks().map(stack -> stack.copyWithCount(qty)).toList());
        IRecipeSlotDrawable outputSlot = recipeSlots.get(1);
        outputSlot.createDisplayOverrides().addItemStacks(outputSlot.getItemStacks().map(stack -> stack.copyWithCount(stack.getCount() * qty)).toList());
        if (recipeSlots.size() > 2) {
            IRecipeSlotDrawable tank = recipeSlots.get(2);
            tank.createDisplayOverrides().addFluidStack((Fluid)IEFluids.CREOSOTE.getStill(), (long)((CokeOvenRecipe)recipe.value()).creosoteOutput * (long)qty);
        }
    }

    @Override
    public void draw(CokeOvenRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.flame.draw(graphics, 31, 20);
    }
}

