/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.inventory.IDropInventory;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class DropInventoryLootEntry
extends LootPoolSingletonContainer {
    public static final MapCodec<DropInventoryLootEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> DropInventoryLootEntry.singletonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DropInventoryLootEntry::new));

    protected DropInventoryLootEntry(int weightIn, int qualityIn, List<LootItemCondition> conditionsIn, List<LootItemFunction> functionsIn) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
    }

    protected void createItemStack(@Nonnull Consumer<ItemStack> output, LootContext context) {
        if (context.hasParam(LootContextParams.BLOCK_ENTITY)) {
            IItemHandler itemHandler;
            IDropInventory ieInvBE;
            BlockEntity te = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
            if (te instanceof IEBlockInterfaces.IGeneralMultiblock) {
                IEBlockInterfaces.IGeneralMultiblock dummyBE = (IEBlockInterfaces.IGeneralMultiblock)te;
                te = (BlockEntity)dummyBE.master();
            }
            if (te instanceof IDropInventory && (ieInvBE = (IDropInventory)te).getDroppedItems() != null) {
                ieInvBE.getDroppedItems().forEach(output);
            } else if (te != null && te.getLevel() != null && (itemHandler = (IItemHandler)te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null)) instanceof IEInventoryHandler) {
                IEInventoryHandler ieHandler = (IEInventoryHandler)itemHandler;
                for (int i = 0; i < ieHandler.getSlots(); ++i) {
                    if (ieHandler.getStackInSlot(i).isEmpty()) continue;
                    output.accept(ieHandler.getStackInSlot(i));
                    ieHandler.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
    }

    public static LootPoolSingletonContainer.Builder<?> builder() {
        return DropInventoryLootEntry.simpleBuilder(DropInventoryLootEntry::new);
    }

    @Nonnull
    public LootPoolEntryType getType() {
        return (LootPoolEntryType)IELootFunctions.DROP_INVENTORY.value();
    }
}

