/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.api.tool.INoisyTool;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class NoisyToolSoundGroup {
    private static final int ATTACK_DURATION = 5;
    private static final int FADE_DURATION = 19;
    private final INoisyTool noisyToolItem;
    private ItemStack noisyToolStack;
    private final int hotbarSlot;
    private final LivingEntity noisyToolHolder;
    private final int harvestTimeoutGrace;
    private ToolMotorState currentMotorState = ToolMotorState.OFF;
    @Nullable
    private BlockPos currentTargetPos = null;
    private long groupLastTickHelper = 0L;

    public NoisyToolSoundGroup(ItemStack noisyToolStack, LivingEntity noisyToolHolder, int hotbarSlot) {
        this.noisyToolStack = noisyToolStack;
        this.noisyToolItem = (INoisyTool)noisyToolStack.getItem();
        this.noisyToolHolder = noisyToolHolder;
        this.hotbarSlot = hotbarSlot;
        this.harvestTimeoutGrace = noisyToolHolder.equals((Object)Minecraft.getInstance().player) ? 4 : 2400;
    }

    private static void play(AbstractTickableSoundInstance soundInstance) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)soundInstance);
    }

    public INoisyTool getItem() {
        return this.noisyToolItem;
    }

    public boolean checkItemValid(ItemStack handItemStack, int hotbarSlot) {
        if (this.hotbarSlot != hotbarSlot || !this.checkItemMatch(handItemStack) || !this.noisyToolItem.ableToMakeNoise(handItemStack)) {
            this.switchMotorOnOff(false);
            return false;
        }
        return true;
    }

    private boolean checkItemMatch(ItemStack handItemStack) {
        if (this.noisyToolStack == handItemStack) {
            return true;
        }
        if (this.noisyToolItem.noisySameStack(this.noisyToolStack, handItemStack)) {
            this.noisyToolStack = handItemStack;
            return true;
        }
        return false;
    }

    public boolean triggerAttack() {
        return this.switchMotorState(true, true, true);
    }

    public boolean switchMotorOnOff(boolean motorOn) {
        return this.switchMotorState(motorOn, false, true);
    }

    private boolean switchMotorState(boolean motorOn, boolean attack, boolean propagate) {
        ToolMotorState newMotorState = motorOn ? (attack ? ToolMotorState.ATTACK : (this.currentTargetPos != null ? ToolMotorState.BUSY : (this.currentMotorState == ToolMotorState.BUSY || this.currentMotorState == ToolMotorState.FADING ? ToolMotorState.FADING : ToolMotorState.IDLE))) : ToolMotorState.OFF;
        if ((this.currentMotorState == newMotorState || propagate && this.currentMotorState == ToolMotorState.ATTACK) && newMotorState != ToolMotorState.ATTACK) {
            return false;
        }
        this.currentMotorState = newMotorState;
        switch (newMotorState.ordinal()) {
            case 0: {
                if (!propagate) break;
                this.updateHarvestState(null, false);
                break;
            }
            case 1: {
                NoisyToolSoundGroup.play(new NoisyToolMotorSoundLooping(this, (SoundEvent)this.noisyToolItem.getIdleSound(this.noisyToolStack).value(), newMotorState));
                break;
            }
            case 2: {
                NoisyToolSoundGroup.play(new NoisyToolMotorSoundLooping(this, (SoundEvent)this.noisyToolItem.getBusySound(this.noisyToolStack).value(), newMotorState));
                break;
            }
            case 3: {
                NoisyToolSoundGroup.play(new NoisyToolMotorSoundFinite((SoundEvent)this.noisyToolItem.getFadingSound(this.noisyToolStack).value(), newMotorState, 19));
                break;
            }
            case 4: {
                if (propagate) {
                    this.updateHarvestState(null, false);
                }
                NoisyToolSoundGroup.play(new NoisyToolMotorSoundFinite((SoundEvent)this.noisyToolItem.getAttackSound(this.noisyToolStack).value(), newMotorState, 5));
            }
        }
        return true;
    }

    public boolean updateHarvestState(@Nullable BlockPos newTargetPos) {
        return this.updateHarvestState(newTargetPos, true);
    }

    private boolean updateHarvestState(@Nullable BlockPos newTargetPos, boolean propagate) {
        this.groupLastTickHelper = this.noisyToolHolder.level().getGameTime();
        if (this.currentMotorState != ToolMotorState.BUSY) {
            this.groupLastTickHelper += (long)this.harvestTimeoutGrace;
        }
        if (Objects.equals(this.currentTargetPos, newTargetPos)) {
            return false;
        }
        this.currentTargetPos = newTargetPos;
        if (newTargetPos != null) {
            if (propagate) {
                this.switchMotorState(true, false, false);
            }
            NoisyToolSoundGroup.play(new NoisyToolHarvestSound(newTargetPos));
        }
        return true;
    }

    public static enum ToolMotorState {
        OFF,
        IDLE,
        BUSY,
        FADING,
        ATTACK,
        TRANSITION;

    }

    private class NoisyToolMotorSoundLooping
    extends NoisyToolMotorSound {
        protected NoisyToolMotorSoundLooping(NoisyToolSoundGroup noisyToolSoundGroup, SoundEvent sound, ToolMotorState state) {
            super(sound, state);
            this.looping = true;
        }
    }

    private class NoisyToolMotorSoundFinite
    extends NoisyToolMotorSound {
        private final long thisSoundsLastTick;

        protected NoisyToolMotorSoundFinite(SoundEvent sound, ToolMotorState state, int duration) {
            super(sound, state);
            NoisyToolSoundGroup.this.groupLastTickHelper = this.thisSoundsLastTick = NoisyToolSoundGroup.this.noisyToolHolder.level().getGameTime() + (long)duration;
        }

        @Override
        public void updateCoordinates() {
            super.updateCoordinates();
            if (this.state == ToolMotorState.ATTACK || this.state == ToolMotorState.FADING) {
                if (this.thisSoundsLastTick != NoisyToolSoundGroup.this.groupLastTickHelper) {
                    this.stop();
                } else if (NoisyToolSoundGroup.this.noisyToolHolder.level().getGameTime() > this.thisSoundsLastTick) {
                    NoisyToolSoundGroup.this.currentMotorState = ToolMotorState.TRANSITION;
                }
            }
        }
    }

    private class NoisyToolHarvestSound
    extends NoisyToolSound {
        private final BlockPos targetBlockPos;

        protected NoisyToolHarvestSound(BlockPos targetBlockPos) {
            super(NoisyToolSoundGroup.this, (SoundEvent)NoisyToolSoundGroup.this.noisyToolItem.getHarvestSound(NoisyToolSoundGroup.this.noisyToolStack).value());
            this.targetBlockPos = targetBlockPos;
            this.x = (double)targetBlockPos.getX() + 0.5;
            this.y = (double)targetBlockPos.getY() + 0.5;
            this.z = (double)targetBlockPos.getZ() + 0.5;
            this.looping = true;
        }

        public void tick() {
            if (!this.isStopped()) {
                if (NoisyToolSoundGroup.this.currentTargetPos != null && (NoisyToolSoundGroup.this.noisyToolHolder.level().getGameTime() > NoisyToolSoundGroup.this.groupLastTickHelper || NoisyToolSoundGroup.this.noisyToolHolder.level().getBlockState(NoisyToolSoundGroup.this.currentTargetPos).isAir())) {
                    NoisyToolSoundGroup.this.currentTargetPos = null;
                }
                if (NoisyToolSoundGroup.this.currentTargetPos == null || !Objects.equals(this.targetBlockPos, NoisyToolSoundGroup.this.currentTargetPos)) {
                    this.stop();
                }
            }
        }
    }

    private abstract class NoisyToolMotorSound
    extends NoisyToolSound {
        protected final ToolMotorState state;

        protected NoisyToolMotorSound(SoundEvent sound, ToolMotorState state) {
            super(NoisyToolSoundGroup.this, sound);
            this.updateCoordinates();
            this.state = state;
        }

        protected void updateCoordinates() {
            this.x = NoisyToolSoundGroup.this.noisyToolHolder.getX();
            this.y = NoisyToolSoundGroup.this.noisyToolHolder.getY() + 0.5;
            this.z = NoisyToolSoundGroup.this.noisyToolHolder.getZ();
        }

        public void tick() {
            if (!this.isStopped()) {
                if (NoisyToolSoundGroup.this.currentMotorState == this.state) {
                    this.updateCoordinates();
                } else {
                    this.stop();
                }
            }
        }
    }

    private abstract class NoisyToolSound
    extends AbstractTickableSoundInstance {
        protected NoisyToolSound(NoisyToolSoundGroup noisyToolSoundGroup, SoundEvent sound) {
            super(sound, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        }

        public boolean canStartSilent() {
            return true;
        }
    }
}

