/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.cogs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndecor.content.blocks.cogs.DnDCogWheelBlock;
import dev.lopyluna.dndecor.register.client.DnDecorPartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class DnDCogwheelRenderer
extends BracketedKineticBlockEntityRenderer {
    public DnDCogwheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BracketedKineticBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        PartialModel model;
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        Direction.Axis axis = DnDCogwheelRenderer.getRotationAxisOf((KineticBlockEntity)be);
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PartialModel partialModel = model = ICogWheel.isLargeCog((BlockState)be.getBlockState()) ? DnDecorPartialModels.DYED_LARGE_COGWHEEL.get(((DnDCogWheelBlock)be.getBlockState().getBlock()).color) : DnDecorPartialModels.DYED_COGWHEEL.get(((DnDCogWheelBlock)be.getBlockState().getBlock()).color);
        if (((DnDCogWheelBlock)be.getBlockState().getBlock()).customModel != null) {
            model = ((DnDCogWheelBlock)be.getBlockState().getBlock()).customModel;
        }
        DnDCogwheelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)model, (BlockState)be.getBlockState(), (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.cutoutMipped()), (int)light);
        float angle = DnDCogwheelRenderer.getAngleForLargeCogShaft((SimpleKineticBlockEntity)be, axis);
        SuperByteBuffer shaft = CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.COGWHEEL_SHAFT, (BlockState)be.getBlockState(), (Direction)facing);
        DnDCogwheelRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
        shaft.renderInto(ms, buffer.getBuffer(RenderType.solid()));
    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, Direction.Axis axis) {
        BlockPos pos = be.getBlockPos();
        float offset = DnDCogwheelRenderer.getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float angle = (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        float offset = 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.getX()) + (axis == Direction.Axis.Y ? 0 : pos.getY()) + (axis == Direction.Axis.Z ? 0 : pos.getZ())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }
}

